/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.util;

import com.google.common.base.Preconditions;

public class TextUtils {
    public static String htmlEncode(String s2) {
        return TextUtils.htmlEncode(s2, true);
    }

    public static String htmlEncode(String s2, boolean encodeSpecialChars) {
        s2 = Preconditions.checkNotNull(s2);
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < s2.length(); ++j) {
            char c = s2.charAt(j);
            if (c < '\u0080') {
                switch (c) {
                    case '\"': {
                        str.append("&quot;");
                        break;
                    }
                    case '&': {
                        str.append("&amp;");
                        break;
                    }
                    case '<': {
                        str.append("&lt;");
                        break;
                    }
                    case '>': {
                        str.append("&gt;");
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
                continue;
            }
            if (encodeSpecialChars && c < '\u00ff') {
                String hexChars = "0123456789ABCDEF";
                int a = c % 16;
                int b = (c - a) / 16;
                String hex = "" + hexChars.charAt(b) + hexChars.charAt(a);
                str.append("&#x").append(hex).append(";");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }
}

