/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class GradleArtifactoryClientConfigUpdater {
    public static void update(ArtifactoryClientConfiguration config, Project project) {
        Properties props = new Properties();
        GradleArtifactoryClientConfigUpdater.fillProperties(project, props);
        StartParameter startParameter = project.getGradle().getStartParameter();
        Map startProps = startParameter.getProjectProperties();
        props.putAll(BuildInfoExtractorUtils.filterStringEntries(startProps));
        Properties mergedProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(props, config.info.getLog());
        Properties buildInfoProperties = BuildInfoExtractorUtils.filterDynamicProperties(mergedProps, BuildInfoExtractorUtils.BUILD_INFO_PROP_PREDICATE);
        buildInfoProperties = BuildInfoExtractorUtils.stripPrefixFromProperties(buildInfoProperties, "buildInfo.property.");
        mergedProps.putAll((Map<?, ?>)buildInfoProperties);
        String prefix = "buildInfo.";
        HashSet<String> excludeIfExist = CommonUtils.newHashSet(prefix + "build.number", prefix + "build.name", prefix + "build.started");
        config.fillFromProperties(mergedProps, excludeIfExist);
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes(config, project.getRootProject().getName(), "Gradle", project.getGradle().getGradleVersion());
    }

    private static void fillProperties(Project project, Properties props) {
        Project parent = project.getParent();
        if (parent != null) {
            GradleArtifactoryClientConfigUpdater.fillProperties(parent, props);
        }
        Map projectProperties = project.getExtensions().getExtraProperties().getProperties();
        props.putAll(BuildInfoExtractorUtils.filterStringEntries(projectProperties));
    }
}

