/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util.version;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.util.version.GradleVersionHelper;
import org.jfrog.bamboo.util.version.MavenVersionHelper;

public abstract class VersionHelper {
    protected PackageManagersContext context;

    protected VersionHelper(PackageManagersContext context) {
        this.context = context;
    }

    public abstract List<ModuleVersionHolder> filterPropertiesForRelease(ImmutablePlan var1, int var2) throws RepositoryException, IOException;

    public abstract void addVersionFieldsToConfiguration(Map var1, Map<String, String> var2, String var3, Map<String, String> var4);

    public String calculateReleaseVersion(String fromVersion) {
        return fromVersion.replace("-SNAPSHOT", "");
    }

    public String calculateNextVersion(String fromVersion) {
        String nextVersion;
        fromVersion = this.calculateReleaseVersion(fromVersion);
        int lastDotIndex = fromVersion.lastIndexOf(46);
        try {
            if (lastDotIndex != -1) {
                String nextMinorVersion;
                String minorVersionToken = fromVersion.substring(lastDotIndex + 1);
                int lastDashIndex = minorVersionToken.lastIndexOf(45);
                if (lastDashIndex != -1) {
                    String buildNumber = minorVersionToken.substring(lastDashIndex + 1);
                    int nextBuildNumber = Integer.parseInt(buildNumber) + 1;
                    nextMinorVersion = minorVersionToken.substring(0, lastDashIndex + 1) + nextBuildNumber;
                } else {
                    nextMinorVersion = Integer.parseInt(minorVersionToken) + 1 + "";
                }
                nextVersion = fromVersion.substring(0, lastDotIndex + 1) + nextMinorVersion;
            } else {
                int nextMajorVersion = Integer.parseInt(fromVersion) + 1;
                nextVersion = nextMajorVersion + "";
            }
        }
        catch (NumberFormatException e) {
            return fromVersion;
        }
        return nextVersion + "-SNAPSHOT";
    }

    public static VersionHelper getHelperAccordingToType(PackageManagersContext context, CapabilityContext capabilityContext) {
        if (context instanceof GradleBuildContext) {
            return new GradleVersionHelper(context);
        }
        if (context instanceof Maven3BuildContext) {
            return new MavenVersionHelper(context, capabilityContext);
        }
        return null;
    }
}

