/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static <V> Map<String, V> filterMapKeysByPrefix(Map<String, V> map, String prefix) {
        HashedMap result = new HashedMap();
        if (map == null) {
            return result;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (!StringUtils.startsWith((String)entry.getKey(), (String)prefix)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <V> Map<String, V> filterPropertiesKeysByPrefix(Properties properties, String prefix) {
        HashedMap result = new HashedMap();
        if (properties == null) {
            return result;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StringUtils.startsWith((String)key, (String)prefix)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String getTaskSecurityToken(BuildContext buildContext, TaskDefinition runtimeTaskDefinition) {
        for (RuntimeTaskDefinition task : buildContext.getRuntimeTaskDefinitions()) {
            if (!task.equals(runtimeTaskDefinition)) continue;
            return (String)task.getRuntimeContext().get("securityToken");
        }
        return null;
    }

    public static String getPluginVersion(PluginAccessor pluginAccessor) {
        Plugin plugin = pluginAccessor.getPlugin("org.jfrog.bamboo.bamboo-artifactory-plugin");
        if (plugin != null) {
            return plugin.getPluginInformation().getVersion();
        }
        return "";
    }
}

