/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;

public class ProxyUtils {
    private static final String KEY_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String KEY_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String KEY_HTTP_PROXY_USER = "http.proxyUser";
    private static final String KEY_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String KEY_HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String KEY_HTTP_PROXY_PORT_DEFAULT = "80";

    public static void setProxyConfig(String artifactoryUrl, ArtifactoryManagerBuilder artifactoryManagerBuilder) {
        ProxyConfiguration proxyConfiguration = ProxyUtils.getProxyConfiguration(artifactoryUrl);
        if (proxyConfiguration != null) {
            artifactoryManagerBuilder.setProxyConfiguration(proxyConfiguration);
        }
    }

    public static void setProxyConfigurationToArtifactoryClientConfig(String artifactoryUrl, ArtifactoryClientConfiguration clientConf) {
        ProxyConfiguration proxyConfiguration = ProxyUtils.getProxyConfiguration(artifactoryUrl);
        if (proxyConfiguration != null) {
            clientConf.proxy.setHost(proxyConfiguration.host);
            clientConf.proxy.setPort(proxyConfiguration.port);
            clientConf.proxy.setUsername(proxyConfiguration.username);
            clientConf.proxy.setPassword(proxyConfiguration.host);
        }
    }

    public static ProxyConfiguration getProxyConfiguration(String artifactoryUrl) throws IllegalArgumentException {
        String proxyHost = System.getProperty(KEY_HTTP_PROXY_HOST);
        if (Strings.isNullOrEmpty(proxyHost)) {
            return null;
        }
        if (ProxyUtils.isNonProxyHost(artifactoryUrl, System.getProperty(KEY_HTTP_NON_PROXY_HOSTS))) {
            return null;
        }
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.host = proxyHost;
        String proxyPort = System.getProperty(KEY_HTTP_PROXY_PORT);
        if (Strings.isNullOrEmpty(proxyPort)) {
            proxyPort = KEY_HTTP_PROXY_PORT_DEFAULT;
        }
        try {
            proxyConfiguration.port = Integer.parseInt(proxyPort);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Provided http.proxyPort is invalid", ex);
        }
        proxyConfiguration.username = System.getProperty(KEY_HTTP_PROXY_USER);
        proxyConfiguration.password = System.getProperty(KEY_HTTP_PROXY_PASSWORD);
        return proxyConfiguration;
    }

    private static boolean isNonProxyHost(String url, String nonProxyHosts) {
        if (url != null && nonProxyHosts != null && nonProxyHosts.length() > 0) {
            String host;
            try {
                URI artifactoryUri = new URI(url);
                host = artifactoryUri.getHost();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Failed checking url for non-proxy-host", ex);
            }
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!host.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                return true;
            }
        }
        return false;
    }
}

