/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.builder.GradleDataHelper;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.task.BaseJavaBuildTask;
import org.jfrog.bamboo.util.ConfigurationPathHolder;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;

public class ArtifactoryGradleTask
extends BaseJavaBuildTask {
    public static final String TASK_NAME = "artifactoryGradleTask";
    public static final String EXECUTABLE_WRAPPER_NAME = SystemUtils.IS_OS_WINDOWS ? "./gradlew.bat" : "./gradlew";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "gradle.bat" : "gradle";
    private static final String GRADLE_KEY = "system.builder.gradle.";
    private AdministrationConfiguration administrationConfiguration;
    private final BuilderDependencyHelper dependencyHelper;
    private final CapabilityContext capabilityContext;
    private GradleBuildContext gradleBuildContext;
    private GradleDataHelper gradleDataHelper;
    private String artifactoryPluginVersion;
    private String gradleDependenciesDir;

    public ArtifactoryGradleTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor, processService);
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryGradleBuilder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.artifactoryPluginVersion = Utils.getPluginVersion(this.pluginAccessor);
        this.gradleBuildContext = this.createBuildContext(context);
        this.initEnvironmentVariables(this.gradleBuildContext);
        this.aggregateBuildInfo = this.gradleBuildContext.shouldAggregateBuildInfo(context);
        this.gradleDataHelper = new GradleDataHelper(this.buildParamsOverrideManager, context, this.gradleBuildContext, this.administrationConfiguration, this.environmentVariableAccessor, this.artifactoryPluginVersion, this.aggregateBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext context) throws TaskException {
        ConfigurationPathHolder pathHolder;
        String altTasks;
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + this.artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        this.logger.getInterceptorStack().add((LogInterceptor)errorLines);
        File rootDirectory = context.getRootDirectory();
        try {
            this.gradleDependenciesDir = this.extractGradleDependencies(this.gradleBuildContext.getArtifactoryServerId(), this.gradleBuildContext);
        }
        catch (IOException e) {
            this.buildInfoLog.error("Error occurred while preparing Artifactory Gradle Runner dependencies. Build Info support is disabled: ", e);
        }
        String gradleCommandLine = this.getExecutable(this.gradleBuildContext);
        if (StringUtils.isBlank((String)gradleCommandLine)) {
            log.error(this.logger.addErrorLogEntry("Gradle executable is not defined!"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
        }
        ArrayList<String> command = Lists.newArrayList(gradleCommandLine);
        String switches = this.gradleBuildContext.getSwitches();
        if (StringUtils.isNotBlank((String)switches)) {
            String[] switchTokens = StringUtils.split((String)switches, (char)' ');
            command.addAll(Arrays.asList(switchTokens));
        }
        String tasks = this.gradleBuildContext.getTasks();
        if (this.gradleBuildContext.releaseManagementContext.isActivateReleaseManagement() && StringUtils.isNotBlank((String)(altTasks = this.gradleBuildContext.releaseManagementContext.getAlternativeTasks()))) {
            tasks = altTasks;
        }
        if (StringUtils.isNotBlank((String)tasks)) {
            String[] taskTokens = StringUtils.split((String)tasks, (char)' ');
            command.addAll(Arrays.asList(taskTokens));
        }
        if ((pathHolder = this.getGradleInitScriptFile(this.gradleDataHelper, this.gradleBuildContext, this.aggregateBuildInfo)) != null) {
            if (!this.gradleBuildContext.useArtifactoryGradlePlugin()) {
                command.add("-I");
                command.add(Commandline.quoteArgument(pathHolder.getInitScriptPath()));
            }
            TaskUtils.appendBuildInfoPropertiesArgument(command, pathHolder.getClientConfPath());
            command.add("artifactoryPublish");
        } else {
            this.aggregateBuildInfo = false;
        }
        String subDirectory = this.gradleBuildContext.getBuildScript();
        if (StringUtils.isNotBlank((String)subDirectory)) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, this.gradleBuildContext, this.capabilityContext);
        this.environmentVariables.put("JAVA_HOME", jdkPath);
        this.gradleDataHelper.addPasswordsSystemProps(command, context);
        ExternalProcess process = this.getExternalProcess(context, rootDirectory, command, this.environmentVariables);
        try {
            this.executeExternalProcess(this.logger, process, log);
            if (this.aggregateBuildInfo) {
                this.convertGeneratedBuildInfoToBuild();
            }
            TaskResult taskResult = this.collectTestResults(this.gradleBuildContext, context, process);
            return taskResult;
        }
        finally {
            context.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.gradleDataHelper.getDeployServer();
    }

    @Override
    protected String getTaskUsageName() {
        return "gradle";
    }

    private GradleBuildContext createBuildContext(CommonTaskContext context) {
        Map<String, String> combinedMap = this.getCombinedConfiguration(context);
        return new GradleBuildContext(combinedMap);
    }

    /*
     * Exception decompiling
     */
    private ConfigurationPathHolder getGradleInitScriptFile(GradleDataHelper initScriptHelper, GradleBuildContext buildContext, boolean aggregateBuildInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getExecutable(PackageManagersContext buildContext) throws TaskException {
        if (buildContext instanceof GradleBuildContext && ((GradleBuildContext)buildContext).isUseGradleWrapper()) {
            String gradleWrapperLocation = ((GradleBuildContext)buildContext).getGradleWrapperLocation();
            if (StringUtils.isNotBlank((String)gradleWrapperLocation)) {
                return gradleWrapperLocation;
            }
            return EXECUTABLE_WRAPPER_NAME;
        }
        return TaskUtils.getExecutablePath(buildContext, this.capabilityContext, GRADLE_KEY, EXECUTABLE_NAME, TASK_NAME, this.containerized);
    }

    private String extractGradleDependencies(long artifactoryServerId, GradleBuildContext context) throws IOException {
        if (artifactoryServerId == -1L && !this.aggregateBuildInfo) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(this.bambooTmp, TaskUtils.getPlanKey(this.customVariableContext), context, PluginProperties.getPluginProperty("gradle.dependency.file.name"));
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }
}

