/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.processor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.bamboo.util.version.VcsHelper;

public class GradlePropertiesCopier
extends AbstractBuildTask
implements CustomBuildProcessor {
    private static final Logger log = LogManager.getLogger(GradlePropertiesCopier.class);
    private volatile ArtifactManager artifactManager;
    private BuildLoggerManager buildLoggerManager;

    @NotNull
    public BuildContext call() {
        PlanResultKey planResultKey = this.buildContext.getPlanResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
        File checkoutDir = VcsHelper.getCheckoutDirectory(this.buildContext);
        if (checkoutDir == null) {
            return this.buildContext;
        }
        List taskDefinitions = this.buildContext.getBuildDefinition().getTaskDefinitions();
        TaskDefinition gradleDefinition = TaskDefinitionHelper.findGradleDefinition(taskDefinitions);
        if (gradleDefinition == null) {
            log.debug("Current build is not a gradle build");
            return this.buildContext;
        }
        if (checkoutDir.exists()) {
            File gradleProps;
            String directory;
            GradleBuildContext gradleBuildContext = (GradleBuildContext)PackageManagersContext.createContextFromMap(gradleDefinition.getConfiguration());
            String location = "";
            String string = directory = gradleBuildContext == null ? "" : gradleBuildContext.getBuildScript();
            if (StringUtils.isNotBlank((String)directory)) {
                location = directory;
            }
            if ((gradleProps = new File(new File(checkoutDir, location), "gradle.properties")).exists()) {
                TaskDefinition definition = TaskDefinitionHelper.findGradleDefinition(this.buildContext.getRuntimeTaskDefinitions());
                String securityToken = Utils.getTaskSecurityToken(this.buildContext, definition);
                if (securityToken == null) {
                    log.error("Security token not found");
                    return this.buildContext;
                }
                ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("gradle", false, SecureToken.createFromString((String)securityToken));
                artifact.setLocation(location);
                artifact.setCopyPattern(gradleProps.getName());
                HashMap config = Maps.newHashMap();
                this.artifactManager.publish(buildLogger, planResultKey, checkoutDir, (ArtifactDefinitionContext)artifact, config, 1);
            }
        }
        return this.buildContext;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

