/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.XrayScanContext;

public class ArtifactoryXrayScanConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String KEY = "artifactoryXrayScanBuilder";
    private static final Set<String> FIELDS_TO_COPY = XrayScanContext.getFieldsToCopy();

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("build", context.get("plan"));
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedServerId", context.get("artifactory.xrayScan.artifactoryServerId"));
        context.put("serverConfigManager", this.serverConfigManager);
        ArtifactoryXrayScanConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        XrayScanContext taskContext = new XrayScanContext(taskConfiguration);
        if (StringUtils.isBlank(taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank(taskContext.getUsername(), taskContext.getPassword())) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        this.decryptFields(configMap);
        return configMap;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        TaskConfigurationValidations.validateArtifactoryServerProvidedAndValid("artifactory.xrayScan.artifactoryServerId", this.serverConfigManager, params, errorCollection);
        TaskConfigurationValidations.validateBuildNameNumber("artifactory.task.buildName", "artifactory.task.buildNumber", params, errorCollection);
    }
}

