/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.NpmBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;

public class ArtifactoryNpmConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String CFG_NPM_COMMAND_INSTALL = "install";
    private static final String CFG_NPM_COMMAND_PUBLISH = "publish";
    private static final String KEY = "artifactoryNpmBuilder";
    private static final Set<String> FIELDS_TO_COPY = NpmBuildContext.getFieldsToCopy();
    private static final Map<String, String> CFG_NPM_COMMAND_OPTIONS = ImmutableMap.of("install", "install", "publish", "pack and publish");

    public ArtifactoryNpmConfiguration() {
        super("artifactory.task.npm.", "system.builder.npm");
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateNpmCommandsContext(context);
        context.put("artifactoryNpmTask", (Object)this);
        context.put("builderType", (Object)this);
        context.put("builder", (Object)this);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedResolutionServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("selectedPublishingServerId", -1);
        context.put("selectedPublishingRepoKey", "");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateNpmCommandsContext(context);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedPublishingServerId", context.get("artifactory.task.npm.artifactoryServerId"));
        context.put("selectedResolutionServerId", context.get("artifactory.task.npm.resolutionArtifactoryServerId"));
        String selectedResolutionRepoKey = context.get("artifactory.task.npm.resolutionRepo") != null ? context.get("artifactory.task.npm.resolutionRepo").toString() : "noResolutionRepoKeyConfigured";
        context.put("selectedResolutionRepoKey", selectedResolutionRepoKey);
        String selectedPublishingRepoKey = context.get("artifactory.task.npm.publishingRepo") != null ? context.get("artifactory.task.npm.publishingRepo").toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedPublishingRepoKey", selectedPublishingRepoKey);
        context.put("serverConfigManager", this.serverConfigManager);
        ArtifactoryNpmConfiguration.populateDefaultEnvVarsExcludePatternsInBuildContext(context);
        ArtifactoryNpmConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        NpmBuildContext taskContext = new NpmBuildContext(taskConfiguration);
        if (StringUtils.isBlank(taskContext.getResolverOverrideCredentialsChoice()) && StringUtils.isNoneBlank(taskContext.getResolverUsername(), taskContext.getResolverPassword())) {
            context.put("resolver.overrideCredentialsChoice", "usernamePassword");
        }
        if (StringUtils.isBlank(taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank(taskContext.getDeployerUsername(), taskContext.getDeployerPassword())) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    private void populateNpmCommandsContext(@NotNull Map<String, Object> context) {
        context.put("npmCommandOptions", CFG_NPM_COMMAND_OPTIONS);
        context.put("artifactory.task.npm.command.choice", CFG_NPM_COMMAND_INSTALL);
    }

    @Override
    protected void resetResolverConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getResolutionArtifactoryServerId();
        if (serverId == -1L) {
            buildContext.resetResolverContextToDefault();
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        NpmBuildContext buildContext = new NpmBuildContext(taskConfigMap);
        this.resetDeployerConfigIfNeeded(buildContext);
        this.resetResolverConfigIfNeeded(buildContext);
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String executableKey;
        String commandChoiceKey = "artifactory.task.npm.command.choice";
        if (CFG_NPM_COMMAND_PUBLISH.equals(params.getString(commandChoiceKey))) {
            String deploymentServerKey = "artifactory.task.npm.artifactoryServerId";
            String deploymentRepoKey = "artifactory.task.npm.publishingRepo";
            TaskConfigurationValidations.validateArtifactoryServerAndRepo(deploymentServerKey, deploymentRepoKey, this.serverConfigManager, params, errorCollection);
        }
        if (StringUtils.isBlank(params.getString(executableKey = "artifactory.task.npm.executable"))) {
            errorCollection.addError(executableKey, "Please specify an Executable.");
        }
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

