/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.GenericContext;

public class AbstractGenericBuildConfiguration
extends AbstractArtifactoryConfiguration {
    static final Set<String> FIELDS_TO_COPY = GenericContext.getFieldsToCopy();

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateLegacyContextForCreate(context);
        context.put("build", context.get("plan"));
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("selectedRepoKey", "");
        context.put("artifactory.generic.envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        context.put("signMethods", GenericContext.SIGN_METHOD_MAP);
        context.put("artifactory.task.buildName", "${bamboo.buildPlanName}");
        context.put("artifactory.task.buildNumber", "${bamboo.buildNumber}");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateLegacyContextForEdit(context, taskDefinition);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        String envVarsExcludePatterns = (String)context.get("artifactory.generic.envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("artifactory.generic.envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        }
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", context.get("builder.artifactoryGenericBuilder.artifactoryServerId"));
        AbstractGenericBuildConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
    }

    @Override
    protected String getKey() {
        return null;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        this.decryptFields(configMap);
        return configMap;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

