/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupRuntimeException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class PlexusJUnit4TestCase {
    private PlexusContainer container;
    private static String basedir;

    @Before
    public void beforeTest() throws Exception {
        basedir = PlexusJUnit4TestCase.getBasedir();
    }

    protected void setupContainer() {
        DefaultContext context = new DefaultContext();
        context.put("basedir", PlexusJUnit4TestCase.getBasedir());
        this.customizeContext(context);
        boolean hasPlexusHome = context.contains("plexus.home");
        if (!hasPlexusHome) {
            File f = PlexusJUnit4TestCase.getTestFile("target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            context.put("plexus.home", f.getAbsolutePath());
        }
        String config = this.getCustomConfigurationName();
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setName("test").setContext(context.getContextData());
        if (config != null) {
            containerConfiguration.setContainerConfiguration(config);
        } else {
            String resource = this.getConfigurationName(null);
            containerConfiguration.setContainerConfiguration(resource);
        }
        this.customizeContainerConfiguration(containerConfiguration);
        try {
            this.container = new DefaultPlexusContainer(containerConfiguration);
        }
        catch (PlexusContainerException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to create plexus container.");
        }
    }

    protected void customizeContainerConfiguration(ContainerConfiguration containerConfiguration) {
    }

    protected void customizeContext(Context context) {
    }

    protected PlexusConfiguration customizeComponentConfiguration() {
        return null;
    }

    @After
    public void afterTest() throws Exception {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected InputStream getConfiguration() {
        return this.getConfiguration(null);
    }

    protected InputStream getConfiguration(String subname) {
        return this.getResourceAsStream(this.getConfigurationName(subname));
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getConfigurationName(String subname) {
        return this.getClass().getName().replace('.', '/') + ".xml";
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.getClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected Object lookup(String componentKey) {
        try {
            return this.getContainer().lookup(componentKey);
        }
        catch (ComponentLookupException e) {
            throw new ComponentLookupRuntimeException(e);
        }
    }

    protected Object lookup(String role, String roleHint) throws ComponentLookupRuntimeException {
        try {
            return this.getContainer().lookup(role, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new ComponentLookupRuntimeException(e);
        }
    }

    protected <T> T lookup(Class<T> componentClass) throws ComponentLookupRuntimeException {
        try {
            return this.getContainer().lookup(componentClass);
        }
        catch (ComponentLookupException e) {
            throw new ComponentLookupRuntimeException(e);
        }
    }

    protected <T> T lookup(Class<T> componentClass, String roleHint) throws ComponentLookupRuntimeException {
        try {
            return this.getContainer().lookup(componentClass, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new ComponentLookupRuntimeException(e);
        }
    }

    protected void release(Object component) throws Exception {
        this.getContainer().release(component);
    }

    public static File getTestFile(String path) {
        return new File(PlexusJUnit4TestCase.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusJUnit4TestCase.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusJUnit4TestCase.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusJUnit4TestCase.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }

    public String getTestConfiguration() {
        return PlexusJUnit4TestCase.getTestConfiguration(this.getClass());
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String s2 = clazz.getName().replace('.', '/');
        return s2.substring(0, s2.indexOf("$")) + ".xml";
    }
}

