/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.internal.aether.LoggingRepositoryListener;
import org.apache.maven.internal.aether.ReverseTreeRepositoryListener;
import org.apache.maven.model.ModelBase;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ChainedLocalRepositoryManager;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.sisu.Nullable;

@Named
public class DefaultRepositorySystemSessionFactory {
    private static final String MAVEN_REPO_LOCAL_TAIL = "maven.repo.local.tail";
    private static final String MAVEN_REPO_LOCAL_TAIL_IGNORE_AVAILABILITY = "maven.repo.local.tail.ignoreAvailability";
    private static final String MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE = "maven.repo.local.recordReverseTree";
    private static final String MAVEN_RESOLVER_TRANSPORT_KEY = "maven.resolver.transport";
    private static final String MAVEN_RESOLVER_TRANSPORT_DEFAULT = "default";
    private static final String MAVEN_RESOLVER_TRANSPORT_WAGON = "wagon";
    private static final String MAVEN_RESOLVER_TRANSPORT_NATIVE = "native";
    private static final String MAVEN_RESOLVER_TRANSPORT_AUTO = "auto";
    private static final String WAGON_TRANSPORTER_PRIORITY_KEY = "aether.priority.WagonTransporterFactory";
    private static final String NATIVE_HTTP_TRANSPORTER_PRIORITY_KEY = "aether.priority.HttpTransporterFactory";
    private static final String NATIVE_FILE_TRANSPORTER_PRIORITY_KEY = "aether.priority.FileTransporterFactory";
    private static final String RESOLVER_MAX_PRIORITY = String.valueOf(Float.MAX_VALUE);
    @Inject
    private Logger logger;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;
    @Inject
    private RepositorySystem repoSystem;
    @Inject
    @Nullable
    @Named(value="ide")
    private WorkspaceReader workspaceRepository;
    @Inject
    private SettingsDecrypter settingsDecrypter;
    @Inject
    private EventSpyDispatcher eventSpyDispatcher;
    @Inject
    MavenRepositorySystem mavenRepositorySystem;
    @Inject
    private RuntimeInformation runtimeInformation;

    public DefaultRepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setCache(request.getRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.put("maven.startTime", request.getStartTime());
        configProps.putAll(this.getPropertiesFromRequestedProfiles(request));
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        if (request.isNoSnapshotUpdates()) {
            session.setUpdatePolicy("never");
        } else if (request.isUpdateSnapshots()) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        session.setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        if (request.getWorkspaceReader() != null) {
            session.setWorkspaceReader(request.getWorkspaceReader());
        } else {
            session.setWorkspaceReader(this.workspaceRepository);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)request.getProxies());
        decrypt.setServers((List)request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt(decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                this.logger.debug(settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector(mirrorSelector);
        DefaultProxySelector defaultProxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            defaultProxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(defaultProxySelector);
        DefaultAuthenticationSelector defaultAuthenticationSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            defaultAuthenticationSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                PlexusConfiguration connectTimeoutXml;
                PlexusConfiguration[] properties;
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
                HashMap<String, String> headers = null;
                Integer connectTimeout = null;
                Integer requestTimeout = null;
                PlexusConfiguration httpHeaders = config.getChild("httpHeaders", false);
                if (httpHeaders != null && (properties = httpHeaders.getChildren("property")) != null && properties.length > 0) {
                    headers = new HashMap<String, String>();
                    for (PlexusConfiguration property : properties) {
                        headers.put(property.getChild("name").getValue(), property.getChild("value").getValue());
                    }
                }
                if ((connectTimeoutXml = config.getChild("connectTimeout", false)) != null) {
                    connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (connectTimeoutXml = httpConfigurationAll.getChild("connectionTimeout", false)) != null) {
                        connectTimeout = Integer.parseInt(connectTimeoutXml.getValue());
                        this.logger.warn("Settings for server " + server.getId() + " uses legacy format");
                    }
                }
                PlexusConfiguration requestTimeoutXml = config.getChild("requestTimeout", false);
                if (requestTimeoutXml != null) {
                    requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                } else {
                    PlexusConfiguration httpConfigurationAll;
                    PlexusConfiguration httpConfiguration = config.getChild("httpConfiguration", false);
                    if (httpConfiguration != null && (httpConfigurationAll = httpConfiguration.getChild("all", false)) != null && (requestTimeoutXml = httpConfigurationAll.getChild("readTimeout", false)) != null) {
                        requestTimeout = Integer.parseInt(requestTimeoutXml.getValue());
                        this.logger.warn("Settings for server " + server.getId() + " uses legacy format");
                    }
                }
                if (headers != null) {
                    configProps.put("aether.connector.http.headers." + server.getId(), headers);
                }
                if (connectTimeout != null) {
                    configProps.put("aether.connector.connectTimeout." + server.getId(), connectTimeout);
                }
                if (requestTimeout != null) {
                    configProps.put("aether.connector.requestTimeout." + server.getId(), requestTimeout);
                }
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(defaultAuthenticationSelector);
        String string = configProps.getOrDefault(MAVEN_RESOLVER_TRANSPORT_KEY, MAVEN_RESOLVER_TRANSPORT_DEFAULT);
        if (!MAVEN_RESOLVER_TRANSPORT_DEFAULT.equals(string)) {
            if (MAVEN_RESOLVER_TRANSPORT_NATIVE.equals(string)) {
                configProps.put(NATIVE_FILE_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
                configProps.put(NATIVE_HTTP_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (MAVEN_RESOLVER_TRANSPORT_WAGON.equals(string)) {
                configProps.put(WAGON_TRANSPORTER_PRIORITY_KEY, RESOLVER_MAX_PRIORITY);
            } else if (!MAVEN_RESOLVER_TRANSPORT_AUTO.equals(string)) {
                throw new IllegalArgumentException("Unknown resolver transport '" + string + "'. Supported transports are: " + MAVEN_RESOLVER_TRANSPORT_WAGON + ", " + MAVEN_RESOLVER_TRANSPORT_NATIVE + ", " + MAVEN_RESOLVER_TRANSPORT_AUTO);
            }
        }
        session.setUserProperties(request.getUserProperties());
        session.setSystemProperties(request.getSystemProperties());
        session.setConfigProperties(configProps);
        session.setTransferListener(request.getTransferListener());
        session.setRepositoryListener(this.eventSpyDispatcher.chainListener(new LoggingRepositoryListener(this.logger)));
        boolean recordReverseTree = ConfigUtils.getBoolean(session, false, MAVEN_REPO_LOCAL_RECORD_REVERSE_TREE);
        if (recordReverseTree) {
            session.setRepositoryListener(new ChainedRepositoryListener(session.getRepositoryListener(), new ReverseTreeRepositoryListener()));
        }
        this.mavenRepositorySystem.injectMirror(request.getRemoteRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getRemoteRepositories());
        this.mavenRepositorySystem.injectMirror(request.getPluginArtifactRepositories(), request.getMirrors());
        this.mavenRepositorySystem.injectProxy(session, request.getPluginArtifactRepositories());
        this.mavenRepositorySystem.injectAuthentication(session, request.getPluginArtifactRepositories());
        this.setUpLocalRepositoryManager(request, session);
        return session;
    }

    private void setUpLocalRepositoryManager(MavenExecutionRequest request, DefaultRepositorySystemSession session) {
        LocalRepository localRepo = new LocalRepository(request.getLocalRepository().getBasedir());
        LocalRepositoryManager lrm = this.repoSystem.newLocalRepositoryManager(session, localRepo);
        String localRepoTail = ConfigUtils.getString(session, null, MAVEN_REPO_LOCAL_TAIL);
        if (localRepoTail != null) {
            boolean ignoreTailAvailability = ConfigUtils.getBoolean(session, true, MAVEN_REPO_LOCAL_TAIL_IGNORE_AVAILABILITY);
            ArrayList<LocalRepositoryManager> tail = new ArrayList<LocalRepositoryManager>();
            List paths = Arrays.stream(localRepoTail.split(",")).filter(p -> p != null && !p.trim().isEmpty()).collect(Collectors.toList());
            for (String path : paths) {
                tail.add(this.repoSystem.newLocalRepositoryManager(session, new LocalRepository(path)));
            }
            session.setLocalRepositoryManager(new ChainedLocalRepositoryManager(lrm, tail, ignoreTailAvailability));
        } else {
            session.setLocalRepositoryManager(lrm);
        }
    }

    private Map<?, ?> getPropertiesFromRequestedProfiles(MavenExecutionRequest request) {
        List<String> activeProfileId = request.getActiveProfiles();
        return request.getProfiles().stream().filter(profile -> activeProfileId.contains(profile.getId())).map(ModelBase::getProperties).flatMap(properties -> properties.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
    }

    private String getUserAgent() {
        String version = this.runtimeInformation.getMavenVersion();
        version = version.isEmpty() ? version : "/" + version;
        return "Apache-Maven" + version + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }
}

