/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.exception.OptionsException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OptionsHelper {
    public static final String OPTPFX = "-";

    private OptionsHelper() {
    }

    public static String applyRule(String ruleName, String serverOptStr, boolean value) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(StringUtils.isNotBlank(serverOptStr), "Null or Empty server options spec", new Object[0]);
        if (StringUtils.isBlank(ruleName)) {
            if (value) {
                return OPTPFX + serverOptStr;
            }
        } else {
            P4JavaExceptions.throwOptionsException("Unrecognized option rule name in options parser: '%s'", ruleName);
        }
        return "";
    }

    public static String applyRule(String ruleName, String serverOptStr, int value) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(StringUtils.isNotBlank(serverOptStr), "Null or Empty server options spec", new Object[0]);
        if (StringUtils.isBlank(ruleName)) {
            return OPTPFX + serverOptStr + value;
        }
        if ("gtz".equals(ruleName) || "clz".equals(ruleName)) {
            if (value > 0) {
                return OPTPFX + serverOptStr + value;
            }
        } else if ("cl".equals(ruleName)) {
            if (value >= 0) {
                return OPTPFX + serverOptStr + (value == 0 ? "default" : Integer.valueOf(value));
            }
        } else if ("dcn".equals(ruleName)) {
            if (value > 0) {
                return OPTPFX + serverOptStr + value;
            }
            if (value == 0) {
                return OPTPFX + serverOptStr;
            }
        } else {
            P4JavaExceptions.throwOptionsException("Unrecognized option rule name in options parser: '%s'", ruleName);
        }
        return "";
    }

    public static String applyRule(String ruleName, String serverOptStr, long value) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(StringUtils.isNotBlank(serverOptStr), "Null or Empty server options spec", new Object[0]);
        if (StringUtils.isBlank(ruleName)) {
            return OPTPFX + serverOptStr + value;
        }
        if ("gtz".equals(ruleName)) {
            if (value > 0L) {
                return OPTPFX + serverOptStr + value;
            }
        } else if ("gez".equals(ruleName)) {
            if (value >= 0L) {
                return OPTPFX + serverOptStr + value;
            }
        } else {
            P4JavaExceptions.throwOptionsException("Unrecognized option rule name in options parser: '%s'", ruleName);
        }
        return "";
    }

    public static String applyRule(String ruleName, String serverOptStr, String value) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(StringUtils.isNotBlank(serverOptStr), "Null or Empty server options spec", new Object[0]);
        if (StringUtils.isBlank(ruleName)) {
            if (StringUtils.isNotBlank(value)) {
                return OPTPFX + serverOptStr + value;
            }
        } else {
            P4JavaExceptions.throwOptionsException("Unrecognized option rule name in options parser: '%s'", ruleName);
        }
        return "";
    }

    public static boolean objectToBoolean(Object optValue) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(Objects.nonNull(optValue), ".option value can not be NULL", new Object[0]);
        if (optValue instanceof String) {
            String value = String.valueOf(optValue);
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            P4JavaExceptions.throwOptionsException("Invalid boolean type options value: %s. \nBoolean type options value is only 'true' or 'false' (case insensitive).", Objects.toString(optValue));
        }
        if (optValue instanceof Boolean) {
            return (Boolean)optValue;
        }
        throw new OptionsException("Invalid boolean type options value: " + Objects.toString(optValue));
    }
}

