/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.mapapi;

import com.perforce.p4java.mapapi.MapFlag;
import com.perforce.p4java.mapapi.MapHalf;
import com.perforce.p4java.mapapi.MapItemArray;
import com.perforce.p4java.mapapi.MapParams;
import com.perforce.p4java.mapapi.MapTableT;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class MapItem {
    public MapItem chain;
    public MapFlag mapFlag;
    public int slot;
    public MapWhole[] halves = new MapWhole[]{new MapWhole(), new MapWhole()};

    public MapWhole whole(MapTableT dir) {
        return this.halves[dir.dir];
    }

    public MapHalf half(MapTableT dir) {
        return this.halves[dir.dir].half;
    }

    public boolean isParent(MapItem other, MapTableT dir) {
        return this.ths(dir).getFixedLen() == this.ths(dir).getCommonLen(other.ths(dir));
    }

    public MapItem(MapItem c, String l, String r, MapFlag f, int s2) {
        this.lhs().set(l);
        this.rhs().set(r);
        this.mapFlag = f;
        this.chain = c;
        this.slot = s2;
        this.halves[0].left = null;
        this.halves[0].center = null;
        this.halves[0].right = null;
        this.halves[1].left = null;
        this.halves[1].center = null;
        this.halves[1].right = null;
    }

    public MapItem(MapItem c, String l, String r, MapFlag f, int s2, int caseMode) {
        this.lhs().set(l);
        this.rhs().set(r);
        this.mapFlag = f;
        this.chain = c;
        this.slot = s2;
        this.halves[0].left = null;
        this.halves[0].center = null;
        this.halves[0].right = null;
        this.halves[1].left = null;
        this.halves[1].center = null;
        this.halves[1].right = null;
        if (caseMode == 0 || caseMode == 1) {
            this.halves[0].half.setCaseMode(caseMode);
            this.halves[1].half.setCaseMode(caseMode);
        }
    }

    public MapHalf lhs() {
        return this.half(MapTableT.LHS);
    }

    public MapHalf rhs() {
        return this.half(MapTableT.RHS);
    }

    public MapHalf ths(MapTableT dir) {
        return this.half(dir);
    }

    public MapHalf ohs(MapTableT dir) {
        return this.half(MapTableT.LHS == dir ? MapTableT.RHS : MapTableT.LHS);
    }

    public MapItem next() {
        return this.chain;
    }

    public MapFlag flag() {
        return this.mapFlag;
    }

    public int slot() {
        return this.slot;
    }

    public MapItem reverse() {
        int top;
        MapItem m3 = this;
        MapItem entry = null;
        int n = top = m3 != null ? m3.slot : 0;
        while (m3 != null) {
            MapItem n2 = m3.chain;
            m3.chain = entry;
            m3.slot = top - m3.slot;
            entry = m3;
            m3 = n2;
        }
        return entry;
    }

    MapItem move(int slot) {
        MapItem m3 = this;
        MapItem entry = m3.chain;
        int start = m3.slot;
        if (start <= slot) {
            return m3;
        }
        if (slot < 0) {
            slot = 0;
        }
        MapItem n = m3.chain;
        while (n != null) {
            if (n.slot != slot) {
                ++n.slot;
                n = n.chain;
                continue;
            }
            ++n.slot;
            m3.slot = slot;
            m3.chain = n.chain;
            n.chain = m3;
            break;
        }
        return entry;
    }

    static MapItem tree(ArrayList<MapItem> items, int start, int end, MapTableT dir, MapItem parent, AtomicInteger depth) {
        int li;
        if (items.size() == 0 || start == end) {
            return null;
        }
        int ri = -1;
        if (start == end - 1 || items.get(start).isParent(items.get(end - 1), dir)) {
            MapWhole t;
            ri = end;
            int overlap = 0;
            AtomicInteger depthBelow = new AtomicInteger(0);
            int maxSlot = 0;
            boolean hasands = false;
            int maxSlotNoAnds = -1;
            int pLength = items.get(start).ths(dir).getFixedLen();
            int last = -1;
            while (--ri > start && items.get(ri).ths(dir).getFixedLen() != pLength) {
            }
            if (parent != null) {
                overlap = items.get(start).ths(dir).getCommonLen(parent.ths(dir));
            }
            if (ri < end - 1) {
                t = items.get(ri).whole(dir);
                t.overlap = overlap;
                t.maxSlot = items.get((int)ri).slot;
                t.left = null;
                t.right = null;
                t.hasands = false;
                t.maxSlotNoAnds = items.get(ri).flag() != MapFlag.MfAndmap ? items.get((int)ri).slot : -1;
                t.center = MapItem.tree(items, ri + 1, end, dir, items.get(ri), depthBelow);
                if (maxSlot < t.maxSlot) {
                    maxSlot = t.maxSlot;
                }
                if (maxSlotNoAnds < t.maxSlotNoAnds) {
                    maxSlotNoAnds = t.maxSlotNoAnds;
                }
                if (t.hasands) {
                    hasands = true;
                }
                if (parent != null && (items.get((int)ri).mapFlag == MapFlag.MfAndmap || t.hasands)) {
                    parent.whole((MapTableT)dir).hasands = true;
                }
                last = ri--;
                depthBelow.incrementAndGet();
            }
            depthBelow.addAndGet(ri - start + 1);
            while (ri >= start) {
                t = items.get(ri).whole(dir);
                t.overlap = overlap;
                if (maxSlot < items.get((int)ri).slot) {
                    maxSlot = items.get((int)ri).slot;
                }
                t.maxSlot = maxSlot;
                if (items.get(ri).flag() != MapFlag.MfAndmap && maxSlotNoAnds < items.get((int)ri).slot) {
                    maxSlotNoAnds = items.get((int)ri).slot;
                }
                t.maxSlotNoAnds = maxSlotNoAnds;
                t.hasands = hasands = last != -1 && items.get((int)last).mapFlag == MapFlag.MfAndmap;
                t.left = null;
                t.right = null;
                t.center = last == -1 ? null : items.get(last);
                last = ri--;
            }
            if (parent != null && parent.whole((MapTableT)dir).maxSlot < maxSlot) {
                parent.whole((MapTableT)dir).maxSlot = maxSlot;
            }
            if (parent != null && parent.whole((MapTableT)dir).maxSlotNoAnds < maxSlotNoAnds) {
                parent.whole((MapTableT)dir).maxSlotNoAnds = maxSlotNoAnds;
            }
            if (parent != null && (hasands || last != -1 && items.get((int)last).mapFlag == MapFlag.MfAndmap)) {
                parent.whole((MapTableT)dir).hasands = true;
            }
            if (depth.get() < depthBelow.get()) {
                depth.set(depthBelow.get());
            }
            return items.get(li);
        }
        ri = start + (end - start) / 2;
        for (li = start; li < ri && !items.get(li).isParent(items.get(ri), dir); ++li) {
        }
        while (ri < end && items.get(li).isParent(items.get(ri), dir)) {
            ++ri;
        }
        MapWhole t = items.get(li).whole(dir);
        AtomicInteger depthBelow = new AtomicInteger(0);
        t.overlap = 0;
        t.maxSlot = items.get((int)li).slot;
        t.hasands = false;
        t.maxSlotNoAnds = items.get(li).flag() != MapFlag.MfAndmap ? items.get((int)li).slot : -1;
        t.left = MapItem.tree(items, start, li, dir, items.get(li), depthBelow);
        t.center = MapItem.tree(items, li + 1, ri, dir, items.get(li), depthBelow);
        t.right = MapItem.tree(items, ri, end, dir, items.get(li), depthBelow);
        if (depth.get() < depthBelow.get() + 1) {
            depth.set(depthBelow.get() + 1);
        }
        if (parent != null) {
            if (parent.whole((MapTableT)dir).maxSlot < t.maxSlot) {
                parent.whole((MapTableT)dir).maxSlot = t.maxSlot;
            }
            if (parent.whole((MapTableT)dir).maxSlotNoAnds < t.maxSlotNoAnds) {
                parent.whole((MapTableT)dir).maxSlotNoAnds = t.maxSlotNoAnds;
            }
            t.overlap = t.half.getCommonLen(parent.ths(dir));
            if (items.get((int)li).mapFlag == MapFlag.MfAndmap || t.hasands) {
                parent.whole((MapTableT)dir).hasands = true;
            }
        }
        return items.get(li);
    }

    MapItem match(MapTableT dir, String from, MapItemArray ands) {
        int coff = 0;
        int best = -1;
        int bestnotands = -1;
        MapItem map = null;
        MapItem tree = this;
        MapParams params = new MapParams();
        if (ands == null && (tree.whole((MapTableT)dir).hasands || tree.flag() == MapFlag.MfAndmap)) {
            ands = new MapItemArray();
        }
        while (tree != null) {
            MapWhole t = tree.whole(dir);
            if (best > t.maxSlot && !t.hasands && tree.flag() != MapFlag.MfAndmap && bestnotands > t.maxSlotNoAnds) break;
            if (coff > t.overlap) {
                coff = t.overlap;
            }
            int r = 0;
            if (coff < t.half.getFixedLen()) {
                r = t.half.match1(from, coff);
            }
            if (r == 0 && best < tree.slot && t.half.match2(from, params)) {
                map = tree;
                best = map.slot;
                if (ands != null) {
                    ands.put(tree, null);
                }
                if (tree.flag() != MapFlag.MfAndmap) {
                    bestnotands = tree.slot;
                }
            }
            if (r == 0 && ands != null && map != tree && best >= tree.slot && t.half.match2(from, params)) {
                ands.put(tree, null);
                if (tree.flag() != MapFlag.MfAndmap) {
                    bestnotands = tree.slot;
                }
            }
            if (r < 0) {
                tree = t.left;
                continue;
            }
            if (r > 0) {
                tree = t.right;
                continue;
            }
            tree = t.center;
        }
        if (map != null && ands != null) {
            MapItem m0 = null;
            int i = 0;
            while ((m0 = ands.getItem(i++)) != null) {
                if (m0.flag() != MapFlag.MfAndmap) {
                    if (m0.mapFlag == MapFlag.MfUnmap) break;
                    map = m0;
                    break;
                }
                if (i != 1) continue;
                map = m0;
            }
        }
        if (map == null || map.mapFlag == MapFlag.MfUnmap) {
            return null;
        }
        return map;
    }

    void dump(StringBuffer buf, MapTableT d, String name) {
        this.dump(buf, d, name, 0);
    }

    void dump(StringBuffer buf, MapTableT d, String name, int l) {
        String indent = "";
        for (int i = 0; i < l && i < 8; ++i) {
            indent = indent + "\t";
        }
        if (l == 0) {
            if (buf == null) {
                System.out.print("MapTree\n");
            } else {
                buf.append("MapTree\n");
            }
        }
        if (this.whole((MapTableT)d).left != null) {
            this.whole((MapTableT)d).left.dump(buf, d, "<<<", l + 1);
        }
        String out = String.format("%s%s %c%s <-> %s%s (maxslot %d (%d))\n", indent, name, Character.valueOf(" -+$@&    123456789".charAt(this.mapFlag.code)), this.ths(d).get(), this.ohs(d).get(), this.whole((MapTableT)d).hasands ? " (has &)" : "", this.whole((MapTableT)d).maxSlot, this.whole((MapTableT)d).maxSlotNoAnds);
        if (buf == null) {
            System.out.print(out);
        } else {
            buf.append(out);
        }
        if (this.whole((MapTableT)d).center != null) {
            this.whole((MapTableT)d).center.dump(buf, d, "===", l + 1);
        }
        if (this.whole((MapTableT)d).right != null) {
            this.whole((MapTableT)d).right.dump(buf, d, ">>>", l + 1);
        }
    }

    public class MapWhole {
        public MapHalf half = new MapHalf();
        public MapItem left;
        public MapItem center;
        public MapItem right;
        public int maxSlot;
        public int overlap;
        public boolean hasands;
        public int maxSlotNoAnds;
    }
}

