/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.ITriggerEntry;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.admin.TriggerEntry;
import com.perforce.p4java.impl.generic.admin.TriggersTable;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ITriggersDelegator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class TriggersDelegator
extends BaseDelegator
implements ITriggersDelegator {
    public TriggersDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String createTriggerEntries(@Nonnull List<ITriggerEntry> entryList) throws P4JavaException {
        Validate.notNull(entryList);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.TRIGGERS, new String[]{"-i"}, InputMapper.map(new TriggersTable(entryList)));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public List<ITriggerEntry> getTriggerEntries() throws P4JavaException {
        ArrayList<ITriggerEntry> triggersList = new ArrayList<ITriggerEntry>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.TRIGGERS, new String[]{"-o"}, null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                String entry;
                if (!Objects.nonNull(map) || ResultMapParser.handleErrorStr(map)) continue;
                int i = 0;
                while (StringUtils.isNotBlank(entry = P4ResultMapUtils.parseString(map, "Triggers" + i))) {
                    triggersList.add(new TriggerEntry(entry, i));
                    ++i;
                }
            }
        }
        return triggersList;
    }

    @Override
    public String updateTriggerEntries(@Nonnull List<ITriggerEntry> entryList) throws P4JavaException {
        return this.createTriggerEntries(entryList);
    }

    @Override
    public InputStream getTriggersTable() throws P4JavaException {
        return this.execStreamCmd(CmdSpec.TRIGGERS, new String[]{"-o"});
    }
}

