/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileRevisionData;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetRevisionHistoryOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IFileLogDelegator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class FileLogDelegator
extends BaseDelegator
implements IFileLogDelegator {
    public FileLogDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, AccessException {
        try {
            GetRevisionHistoryOptions revisionHistoryOptions = new GetRevisionHistoryOptions().setContentHistory(contentHistory).setIncludeInherited(includeInherited).setLongOutput(longOutput).setTruncatedLongOutput(truncatedLongOutput).setMaxRevs(maxRevs);
            return this.getRevisionHistory(fileSpecs, revisionHistoryOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getRevisionHistory: %s", exc.getLocalizedMessage());
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, GetRevisionHistoryOptions opts) throws P4JavaException {
        HashMap<IFileSpec, List<IFileRevisionData>> fileRevisionDataMap = new HashMap<IFileSpec, List<IFileRevisionData>>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FILELOG, Parameters.processParameters(opts, fileSpecs, this.server), null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> resultMap : resultMaps) {
                String depotPath = P4ResultMapUtils.parseString(resultMap, "depotFile");
                String errStr = ResultMapParser.handleFileErrorStr(resultMap);
                if (StringUtils.isNotBlank(errStr)) {
                    FileSpec fileSpec = new FileSpec(FileSpecOpStatus.ERROR, errStr, P4ResultMapUtils.parseCode0ErrorString(resultMap));
                    fileSpec.setDepotPath(depotPath);
                    fileRevisionDataMap.put(fileSpec, null);
                    continue;
                }
                ArrayList<FileRevisionData> fileRevisionDataList = new ArrayList<FileRevisionData>();
                fileRevisionDataList.addAll(FileLogDelegator.parseFileRevisionDataList(resultMap));
                FileSpec fileSpec = new FileSpec();
                fileSpec.setDepotPath(depotPath);
                fileRevisionDataMap.put(fileSpec, fileRevisionDataList);
            }
        }
        return fileRevisionDataMap;
    }

    private static List<FileRevisionData> parseFileRevisionDataList(@Nonnull Map<String, Object> resultMap) {
        ArrayList<FileRevisionData> fileRevisionDataList = new ArrayList<FileRevisionData>();
        int revisionNumber = 0;
        while (Objects.nonNull(resultMap.get("rev" + revisionNumber))) {
            fileRevisionDataList.add(new FileRevisionData(resultMap, revisionNumber));
            ++revisionNumber;
        }
        return fileRevisionDataList;
    }
}

