/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class Depot
extends ServerResource
implements IDepot {
    private String name = null;
    private String ownerName = null;
    private Date modDate = null;
    private String description = null;
    private IDepot.DepotType depotType = null;
    private String address = null;
    private String suffix = null;
    private String streamDepth = null;
    private String map = null;
    private ViewMap<IMapEntry> specMap = new ViewMap();

    public Depot() {
        super(false, false);
    }

    public Depot(Map<String, Object> depotMap) {
        super(false, false);
        if (Objects.nonNull(depotMap)) {
            try {
                this.name = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "name"), P4ResultMapUtils.parseString(depotMap, "Depot"));
                this.ownerName = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "owner"), P4ResultMapUtils.parseString(depotMap, "Owner"));
                try {
                    if (Objects.nonNull(depotMap.get("time"))) {
                        this.modDate = new Date(P4ResultMapUtils.parseLong(depotMap, "time"));
                    } else if (Objects.nonNull(depotMap.get("Date"))) {
                        FastDateFormat dateFormat = FastDateFormat.getInstance("yyyy/MM/dd HH:mm:ss");
                        this.modDate = dateFormat.parse(P4ResultMapUtils.parseString(depotMap, "Date"));
                    }
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in Depot constructor: %s", thr.getLocalizedMessage());
                    Log.exception(thr);
                }
                this.description = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "desc"), P4ResultMapUtils.parseString(depotMap, "Description"));
                if (StringUtils.isNotBlank(this.description) && this.description.length() > 1 && StringUtils.endsWith(this.description, "\n")) {
                    this.description = StringUtils.substring(this.description, 0, this.description.length() - 1);
                }
                if (Objects.nonNull(depotMap.get("type"))) {
                    this.depotType = IDepot.DepotType.fromString(StringUtils.upperCase(P4ResultMapUtils.parseString(depotMap, "type")));
                } else if (Objects.nonNull(depotMap.get("Type"))) {
                    this.depotType = IDepot.DepotType.fromString(StringUtils.upperCase(P4ResultMapUtils.parseString(depotMap, "Type")));
                }
                switch (this.depotType) {
                    case REMOTE: {
                        this.address = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "extra"), P4ResultMapUtils.parseString(depotMap, "Address"));
                        break;
                    }
                    case SPEC: {
                        this.suffix = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "extra"), P4ResultMapUtils.parseString(depotMap, "Suffix"));
                        int i = 0;
                        while (depotMap.containsKey("SpecMap" + i)) {
                            if (Objects.nonNull(depotMap.get("SpecMap" + i))) {
                                try {
                                    String path = P4ResultMapUtils.parseString(depotMap, "SpecMap" + i);
                                    this.specMap.getEntryList().add(new MapEntry(i, path));
                                }
                                catch (Throwable thr) {
                                    Log.error("Unexpected exception in depot spec depotMap-based constructor: %s", thr.getLocalizedMessage());
                                    Log.exception(thr);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case STREAM: {
                        this.streamDepth = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "depth"), P4ResultMapUtils.parseString(depotMap, "StreamDepth"));
                        break;
                    }
                }
                this.map = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(depotMap, "map"), P4ResultMapUtils.parseString(depotMap, "Map"));
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in Depot constructor: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String map) {
        this(name, ownerName, modDate, description, depotType, address, suffix, null, map);
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String streamDepth, String map) {
        this(name, ownerName, modDate, description, depotType, address, suffix, streamDepth, map, null);
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String streamDepth, String map, ViewMap<IMapEntry> specMap) {
        this.name = name;
        this.ownerName = ownerName;
        this.modDate = modDate;
        this.description = description;
        this.depotType = depotType;
        this.address = address;
        this.suffix = suffix;
        this.map = map;
        this.specMap = specMap;
        if (depotType == IDepot.DepotType.STREAM) {
            this.streamDepth = StringHelper.firstNonBlank(streamDepth, "1");
        }
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public IDepot.DepotType getDepotType() {
        return this.depotType;
    }

    public void setDepotType(IDepot.DepotType depotType) {
        this.depotType = depotType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    @Override
    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public ViewMap<IMapEntry> getSpecMap() {
        return this.specMap;
    }

    public void setSpecMap(ViewMap<IMapEntry> specMap) {
        this.specMap = specMap;
    }

    @Override
    public String getStreamDepth() {
        return this.streamDepth;
    }

    public void setStreamDepth(String streamDepth) {
        this.streamDepth = streamDepth;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

