/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.repository;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RepositoryPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepository
implements ArtifactRepository {
    private static final Pattern URL_PATTERN = Pattern.compile("([^:/]+(:[^:/]{2,}+(?=://))?):(//([^@/]*@)?([^/:]+))?.*");
    private String id = "";
    private String type = "";
    private String url = "";
    private RepositoryPolicy releasePolicy;
    private RepositoryPolicy snapshotPolicy;
    private Proxy proxy;
    private Authentication authentication;
    private List<RemoteRepository> mirroredRepositories = Collections.emptyList();
    private boolean repositoryManager;

    public RemoteRepository() {
        this.setPolicy(true, null);
        this.setPolicy(false, null);
    }

    public RemoteRepository(RemoteRepository repository) {
        this.setId(repository.getId());
        this.setContentType(repository.getContentType());
        this.setUrl(repository.getUrl());
        this.setPolicy(true, repository.getPolicy(true));
        this.setPolicy(false, repository.getPolicy(false));
        this.setAuthentication(repository.getAuthentication());
        this.setProxy(repository.getProxy());
        this.setMirroredRepositories(repository.getMirroredRepositories());
        this.setRepositoryManager(repository.isRepositoryManager());
    }

    public RemoteRepository(String id, String type, String url) {
        this.setId(id);
        this.setContentType(type);
        this.setUrl(url);
        this.setPolicy(true, null);
        this.setPolicy(false, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public RemoteRepository setId(String id) {
        this.id = id != null ? id : "";
        return this;
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    public RemoteRepository setContentType(String type) {
        this.type = type != null ? type : "";
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public RemoteRepository setUrl(String url) {
        this.url = url != null ? url : "";
        return this;
    }

    public String getProtocol() {
        Matcher m3 = URL_PATTERN.matcher(this.url);
        if (m3.matches()) {
            return m3.group(1);
        }
        return "";
    }

    public String getHost() {
        String host;
        Matcher m3 = URL_PATTERN.matcher(this.url);
        if (m3.matches() && (host = m3.group(5)) != null) {
            return host;
        }
        return "";
    }

    public RepositoryPolicy getPolicy(boolean snapshot) {
        return snapshot ? this.snapshotPolicy : this.releasePolicy;
    }

    public RemoteRepository setPolicy(boolean snapshot, RepositoryPolicy policy) {
        if (policy == null) {
            policy = new RepositoryPolicy();
        }
        if (snapshot) {
            this.snapshotPolicy = policy;
        } else {
            this.releasePolicy = policy;
        }
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public RemoteRepository setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public RemoteRepository setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public List<RemoteRepository> getMirroredRepositories() {
        return this.mirroredRepositories;
    }

    public RemoteRepository setMirroredRepositories(List<RemoteRepository> mirroredRepositories) {
        this.mirroredRepositories = mirroredRepositories == null || mirroredRepositories.isEmpty() ? Collections.emptyList() : mirroredRepositories;
        return this;
    }

    public boolean isRepositoryManager() {
        return this.repositoryManager;
    }

    public RemoteRepository setRepositoryManager(boolean repositoryManager) {
        this.repositoryManager = repositoryManager;
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.getId());
        buffer.append(" (").append(this.getUrl());
        boolean r = this.getPolicy(false).isEnabled();
        boolean s2 = this.getPolicy(true).isEnabled();
        if (r && s2) {
            buffer.append(", releases+snapshots");
        } else if (r) {
            buffer.append(", releases");
        } else if (s2) {
            buffer.append(", snapshots");
        } else {
            buffer.append(", disabled");
        }
        if (this.isRepositoryManager()) {
            buffer.append(", managed");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RemoteRepository that = (RemoteRepository)obj;
        return RemoteRepository.eq(this.url, that.url) && RemoteRepository.eq(this.type, that.type) && RemoteRepository.eq(this.id, that.id) && RemoteRepository.eq(this.releasePolicy, that.releasePolicy) && RemoteRepository.eq(this.snapshotPolicy, that.snapshotPolicy) && RemoteRepository.eq(this.proxy, that.proxy) && RemoteRepository.eq(this.authentication, that.authentication) && RemoteRepository.eq(this.mirroredRepositories, that.mirroredRepositories) && this.repositoryManager == that.repositoryManager;
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + RemoteRepository.hash(this.url);
        hash = hash * 31 + RemoteRepository.hash(this.type);
        hash = hash * 31 + RemoteRepository.hash(this.id);
        hash = hash * 31 + RemoteRepository.hash(this.releasePolicy);
        hash = hash * 31 + RemoteRepository.hash(this.snapshotPolicy);
        hash = hash * 31 + RemoteRepository.hash(this.proxy);
        hash = hash * 31 + RemoteRepository.hash(this.authentication);
        hash = hash * 31 + RemoteRepository.hash(this.mirroredRepositories);
        hash = hash * 31 + (this.repositoryManager ? 1 : 0);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

