/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.SessionData;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.UpdateCheck;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.impl.internal.SimpleDigest;
import org.sonatype.aether.impl.internal.TrackingFileManager;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.MetadataTransferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=UpdateCheckManager.class)
public class DefaultUpdateCheckManager
implements UpdateCheckManager,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    private static final String UPDATED_KEY_SUFFIX = ".lastUpdated";
    private static final String ERROR_KEY_SUFFIX = ".error";
    private static final String NOT_FOUND = "";
    private static final String SESSION_CHECKS = "updateCheckManager.checks";

    public DefaultUpdateCheckManager() {
    }

    public DefaultUpdateCheckManager(Logger logger) {
        this.setLogger(logger);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
    }

    public DefaultUpdateCheckManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    @Override
    public String getEffectiveUpdatePolicy(RepositorySystemSession session, String policy1, String policy2) {
        return this.ordinalOfUpdatePolicy(policy1) < this.ordinalOfUpdatePolicy(policy2) ? policy1 : policy2;
    }

    private int ordinalOfUpdatePolicy(String policy) {
        if ("daily".equals(policy)) {
            return 1440;
        }
        if ("always".equals(policy)) {
            return 0;
        }
        if (policy != null && policy.startsWith("interval")) {
            String s2 = policy.substring("interval".length() + 1);
            return Integer.valueOf(s2);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void checkArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", locally installed artifact up-to-date.");
            }
            check.setRequired(false);
            return;
        }
        Artifact artifact = check.getItem();
        RemoteRepository repository = check.getRepository();
        File artifactFile = check.getFile();
        if (artifactFile == null) {
            throw new IllegalArgumentException(String.format("The artifact '%s' has no file attached", artifact));
        }
        boolean fileExists = check.isFileValid() && artifactFile.exists();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(artifactFile, repository);
        String dataKey = this.getDataKey(artifact, artifactFile, repository);
        String error = this.getError(props, dataKey);
        if (fileExists) {
            lastUpdated = artifactFile.lastModified();
        } else if (error == null) {
            lastUpdated = 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(artifact, artifactFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (this.isAlreadyUpdated(session.getData(), updateKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", already updated during this session.");
            }
            check.setRequired(false);
            if (error != null) {
                check.setException(this.newException(error, artifact, repository));
            }
        } else if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", locally cached artifact up-to-date.");
            }
            check.setRequired(false);
        } else if (error == null || error.length() <= 0) {
            if (session.isNotFoundCachingEnabled()) {
                check.setRequired(false);
                check.setException(this.newException(error, artifact, repository));
            } else {
                check.setRequired(true);
            }
        } else if (session.isTransferErrorCachingEnabled()) {
            check.setRequired(false);
            check.setException(this.newException(error, artifact, repository));
        } else {
            check.setRequired(true);
        }
    }

    private ArtifactTransferException newException(String error, Artifact artifact, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new ArtifactNotFoundException(artifact, repository, "Failure to find " + artifact + " in " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced");
        }
        return new ArtifactTransferException(artifact, repository, "Failure to transfer " + artifact + " from " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error);
    }

    @Override
    public void checkMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", locally installed metadata up-to-date.");
            }
            check.setRequired(false);
            return;
        }
        Metadata metadata = check.getItem();
        RemoteRepository repository = check.getRepository();
        File metadataFile = check.getFile();
        if (metadataFile == null) {
            throw new IllegalArgumentException(String.format("The metadata '%s' has no file attached", metadata));
        }
        boolean fileExists = check.isFileValid() && metadataFile.exists();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(metadataFile, repository);
        String dataKey = this.getDataKey(metadata, metadataFile, check.getAuthoritativeRepository());
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? this.getLastUpdated(props, dataKey) : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(metadata, metadataFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (this.isAlreadyUpdated(session.getData(), updateKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", already updated during this session.");
            }
            check.setRequired(false);
            if (error != null) {
                check.setException(this.newException(error, metadata, repository));
            }
        } else if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote update check for " + check.getItem() + ", locally cached metadata up-to-date.");
            }
            check.setRequired(false);
        } else if (error == null || error.length() <= 0) {
            check.setRequired(false);
            check.setException(this.newException(error, metadata, repository));
        } else if (session.isTransferErrorCachingEnabled()) {
            check.setRequired(false);
            check.setException(this.newException(error, metadata, repository));
        } else {
            check.setRequired(true);
        }
    }

    private MetadataTransferException newException(String error, Metadata metadata, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new MetadataNotFoundException(metadata, repository, "Failure to find " + metadata + " in " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced");
        }
        return new MetadataTransferException(metadata, repository, "Failure to transfer " + metadata + " from " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error);
    }

    private long getLastUpdated(Properties props, String key) {
        String value = props.getProperty(key + UPDATED_KEY_SUFFIX, NOT_FOUND);
        try {
            return value.length() > 0 ? Long.parseLong(value) : 1L;
        }
        catch (NumberFormatException e) {
            this.logger.debug("Cannot parse lastUpdated date: '" + value + "'. Ignoring.", e);
            return 1L;
        }
    }

    private String getError(Properties props, String key) {
        return props.getProperty(key + ERROR_KEY_SUFFIX);
    }

    private File getTouchFile(Artifact artifact, File artifactFile) {
        return new File(artifactFile.getPath() + UPDATED_KEY_SUFFIX);
    }

    private File getTouchFile(Metadata metadata, File metadataFile) {
        return new File(metadataFile.getParent(), "resolver-status.properties");
    }

    private String getDataKey(Artifact artifact, File artifactFile, RemoteRepository repository) {
        Set<String> mirroredUrls = Collections.emptySet();
        if (repository.isRepositoryManager()) {
            mirroredUrls = new TreeSet<String>();
            for (RemoteRepository mirroredRepository : repository.getMirroredRepositories()) {
                mirroredUrls.add(this.normalizeRepoUrl(mirroredRepository.getUrl()));
            }
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        for (String mirroredUrl : mirroredUrls) {
            buffer.append('+').append(mirroredUrl);
        }
        return buffer.toString();
    }

    private String getTransferKey(Artifact artifact, File artifactFile, RemoteRepository repository) {
        return this.getRepoKey(repository);
    }

    private String getDataKey(Metadata metadata, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName();
    }

    private String getTransferKey(Metadata metadata, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName() + '/' + this.getRepoKey(repository);
    }

    private String getRepoKey(RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(128);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            this.appendAuth(buffer, proxy.getAuthentication());
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        Authentication auth = repository.getAuthentication();
        this.appendAuth(buffer, auth);
        buffer.append(repository.getContentType()).append('-');
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        return buffer.toString();
    }

    private String normalizeRepoUrl(String url) {
        String result = url;
        if (url != null && !url.endsWith("/")) {
            result = url + '/';
        }
        return result;
    }

    private void appendAuth(StringBuilder buffer, Authentication auth) {
        if (auth != null) {
            SimpleDigest digest = new SimpleDigest();
            digest.update(auth.getUsername());
            digest.update(auth.getPassword());
            digest.update(auth.getPrivateKeyFile());
            digest.update(auth.getPassphrase());
            buffer.append(digest.digest()).append('@');
        }
    }

    private String getUpdateKey(File file, RemoteRepository repository) {
        return file.getAbsolutePath() + '|' + this.getRepoKey(repository);
    }

    private boolean isAlreadyUpdated(SessionData data, Object updateKey) {
        Object checkedFiles = data.get(SESSION_CHECKS);
        if (!(checkedFiles instanceof Map)) {
            return false;
        }
        return ((Map)checkedFiles).containsKey(updateKey);
    }

    private void setUpdated(SessionData data, Object updateKey) {
        ConcurrentHashMap old;
        Object checkedFiles = data.get(SESSION_CHECKS);
        while (!(checkedFiles instanceof Map) && !data.set(SESSION_CHECKS, old = checkedFiles, checkedFiles = new ConcurrentHashMap(256))) {
            checkedFiles = data.get(SESSION_CHECKS);
        }
        ((Map)checkedFiles).put(updateKey, Boolean.TRUE);
    }

    @Override
    public boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        boolean checkForUpdates;
        if (policy == null) {
            policy = NOT_FOUND;
        }
        if ("always".equals(policy)) {
            checkForUpdates = true;
        } else if ("daily".equals(policy)) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else if (policy.startsWith("interval")) {
            int minutes;
            try {
                String s2 = policy.substring("interval".length() + 1);
                minutes = Integer.valueOf(s2);
            }
            catch (RuntimeException e) {
                minutes = 1440;
                this.logger.warn("Non-parseable repository update policy '" + policy + "', assuming '" + "interval" + ":1440'");
            }
            Calendar cal = Calendar.getInstance();
            cal.add(12, -minutes);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else {
            checkForUpdates = false;
            if (!"never".equals(policy)) {
                this.logger.warn("Unknown repository update policy '" + policy + "', assuming '" + "never" + "'");
            }
        }
        return checkForUpdates;
    }

    private Properties read(File touchFile) {
        Properties props = new TrackingFileManager().setLogger(this.logger).read(touchFile);
        return props != null ? props : new Properties();
    }

    @Override
    public void touchArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        Artifact artifact = check.getItem();
        File artifactFile = check.getFile();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        String updateKey = this.getUpdateKey(artifactFile, check.getRepository());
        String dataKey = this.getDataKey(artifact, artifactFile, check.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(artifact, artifactFile, check.getRepository());
        this.setUpdated(session.getData(), updateKey);
        Properties props = this.write(touchFile, dataKey, transferKey, check.getException());
        if (artifactFile.exists() && !this.hasErrors(props)) {
            touchFile.delete();
        }
    }

    private boolean hasErrors(Properties props) {
        for (Object key : props.keySet()) {
            if (!key.toString().endsWith(ERROR_KEY_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void touchMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        Metadata metadata = check.getItem();
        File metadataFile = check.getFile();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        String updateKey = this.getUpdateKey(metadataFile, check.getRepository());
        String dataKey = this.getDataKey(metadata, metadataFile, check.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(metadata, metadataFile, check.getRepository());
        this.setUpdated(session.getData(), updateKey);
        this.write(touchFile, dataKey, transferKey, check.getException());
    }

    private Properties write(File touchFile, String dataKey, String transferKey, Exception error) {
        HashMap<String, String> updates = new HashMap<String, String>();
        String timestamp = Long.toString(System.currentTimeMillis());
        if (error == null) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, null);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else if (error instanceof ArtifactNotFoundException || error instanceof MetadataNotFoundException) {
            updates.put(dataKey + ERROR_KEY_SUFFIX, NOT_FOUND);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, null);
        } else {
            String msg = error.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = error.getClass().getSimpleName();
            }
            updates.put(dataKey + ERROR_KEY_SUFFIX, msg);
            updates.put(dataKey + UPDATED_KEY_SUFFIX, null);
            updates.put(transferKey + UPDATED_KEY_SUFFIX, timestamp);
        }
        return new TrackingFileManager().setLogger(this.logger).update(touchFile, updates);
    }
}

