/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.ModuleExtractorUtils;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Issue;
import org.jfrog.build.extractor.ci.IssueTracker;
import org.jfrog.build.extractor.ci.Issues;
import org.jfrog.build.extractor.ci.MatrixParameter;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;

public class GradleBuildInfoExtractor
implements BuildInfoExtractor<Project> {
    private static final Logger log = Logging.getLogger(GradleBuildInfoExtractor.class);
    private final ArtifactoryClientConfiguration clientConf;
    private final List<ModuleInfoFileProducer> moduleInfoFileProducers;

    public GradleBuildInfoExtractor(ArtifactoryClientConfiguration clientConf, List<ModuleInfoFileProducer> moduleInfoFileProducers) {
        this.clientConf = clientConf;
        this.moduleInfoFileProducers = moduleInfoFileProducers;
    }

    @Override
    public BuildInfo extract(Project rootProject) {
        String issueTrackerName;
        Vcs vcs;
        String vcsUrl;
        String vcsRevision;
        String principal;
        String buildName = this.clientConf.info.getBuildName();
        BuildInfoBuilder bib = new BuildInfoBuilder(buildName);
        String buildNumber = this.clientConf.info.getBuildNumber();
        bib.number(buildNumber);
        String buildProject = this.clientConf.info.getProject();
        bib.project(buildProject);
        String buildStartedIso = this.clientConf.info.getBuildStarted();
        Date buildStartDate = null;
        try {
            buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
        }
        catch (ParseException e) {
            log.error("Build start date format error: " + buildStartedIso, (Throwable)e);
        }
        bib.started(buildStartedIso);
        BuildAgent buildAgent = new BuildAgent(this.clientConf.info.getBuildAgentName(), this.clientConf.info.getBuildAgentVersion());
        bib.buildAgent(buildAgent);
        String agentName = this.clientConf.info.getAgentName();
        String agentVersion = this.clientConf.info.getAgentVersion();
        if (StringUtils.isNotBlank(agentName) && StringUtils.isNotBlank(agentVersion)) {
            bib.agent(new Agent(agentName, agentVersion));
        } else {
            bib.agent(new Agent(buildAgent.getName(), buildAgent.getVersion()));
        }
        long durationMillis = buildStartDate != null ? System.currentTimeMillis() - buildStartDate.getTime() : 0L;
        bib.durationMillis(durationMillis);
        Set<File> moduleFilesWithModules = this.moduleInfoFileProducers.stream().filter(ModuleInfoFileProducer::hasModules).flatMap(moduleInfoFileProducer -> moduleInfoFileProducer.getModuleInfoFiles().getFiles().stream()).collect(Collectors.toSet());
        moduleFilesWithModules.forEach(moduleFile -> {
            try {
                Module module = ModuleExtractorUtils.readModuleFromFile(moduleFile);
                List<Artifact> artifacts = module.getArtifacts();
                List<Dependency> dependencies = module.getDependencies();
                if (artifacts != null && !artifacts.isEmpty() || dependencies != null && !dependencies.isEmpty()) {
                    bib.addModule(module);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load module info from file: " + moduleFile.getAbsolutePath(), e);
            }
        });
        String parentName = this.clientConf.info.getParentBuildName();
        String parentNumber = this.clientConf.info.getParentBuildNumber();
        if (parentName != null && parentNumber != null) {
            bib.parentName(parentName);
            bib.parentNumber(parentNumber);
        }
        if (StringUtils.isBlank(principal = this.clientConf.info.getPrincipal())) {
            principal = System.getProperty("user.name");
        }
        bib.principal(principal);
        String artifactoryPrincipal = this.clientConf.publisher.getUsername();
        if (StringUtils.isBlank(artifactoryPrincipal)) {
            artifactoryPrincipal = System.getProperty("user.name");
        }
        bib.artifactoryPrincipal(artifactoryPrincipal);
        String artifactoryPluginVersion = this.clientConf.info.getArtifactoryPluginVersion();
        if (StringUtils.isBlank(artifactoryPluginVersion)) {
            artifactoryPluginVersion = "Unknown";
        }
        bib.artifactoryPluginVersion(artifactoryPluginVersion);
        String buildUrl = this.clientConf.info.getBuildUrl();
        if (StringUtils.isNotBlank(buildUrl)) {
            bib.url(buildUrl);
        }
        if (StringUtils.isNotBlank(vcsRevision = this.clientConf.info.getVcsRevision())) {
            bib.vcsRevision(vcsRevision);
        }
        if (StringUtils.isNotBlank(vcsUrl = this.clientConf.info.getVcsUrl())) {
            bib.vcsUrl(vcsUrl);
        }
        if (!(vcs = new Vcs(vcsUrl, vcsRevision, this.clientConf.info.getVcsBranch(), this.clientConf.info.getVcsMessage())).isEmpty()) {
            bib.vcs(Arrays.asList(vcs));
        }
        if (this.clientConf.info.isReleaseEnabled().booleanValue()) {
            String stagingRepository = this.clientConf.publisher.getRepoKey();
            String comment = this.clientConf.info.getReleaseComment();
            if (comment == null) {
                comment = "";
            }
            bib.addStatus(new PromotionStatusBuilder("Staged").timestampDate(buildStartDate).comment(comment).repository(stagingRepository).ciUser(principal).user(artifactoryPrincipal).build());
        }
        if (StringUtils.isNotBlank(issueTrackerName = this.clientConf.info.issues.getIssueTrackerName())) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(this.clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(this.clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, this.clientConf.info.issues.getIssueTrackerVersion()));
            Set<Issue> set = this.clientConf.info.issues.getAffectedIssuesSet();
            if (!set.isEmpty()) {
                issues.setAffectedIssues(set);
            }
            bib.issues(issues);
        }
        for (Map.Entry entry : this.clientConf.info.getRunParameters().entrySet()) {
            MatrixParameter matrixParameter = new MatrixParameter((String)entry.getKey(), (String)entry.getValue());
            bib.addRunParameters(matrixParameter);
        }
        BuildInfo buildInfo = bib.build();
        PackageManagerUtils.collectEnvAndFilterProperties(this.clientConf, buildInfo);
        log.debug("buildInfoBuilder = " + buildInfo);
        return buildInfo;
    }
}

