/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.vcs.perforce;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.ILabelMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.core.file.FileSpecBuilder;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.ServerFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PerforceClient {
    private IOptionsServer server;
    private IClient client;

    private PerforceClient(String hostAddress, String clientId, String username, String password, String charset) throws IOException {
        this.createServer(hostAddress, clientId, username, password, charset);
    }

    public PerforceClient(IOptionsServer server, IClient client) throws Exception {
        this.server = server;
        this.client = client;
    }

    public void initConnection() throws Exception {
        if (this.server != null) {
            this.server.setCurrentClient(this.client);
            this.server.connect();
        }
    }

    private void createServer(String hostAddress, String clientId, String username, String password, String charset) throws IOException {
        try {
            Properties props = new Properties();
            props.put("autoConnect", (Object)true);
            props.put("autoLogin", (Object)true);
            this.initServerWithTrust(hostAddress, props);
            if (!StringUtils.isBlank(charset)) {
                if (PerforceCharsets.isSupported(charset)) {
                    this.server.setCharsetName(charset);
                } else {
                    this.server.setCharsetName("none");
                }
            }
            this.server.connect();
            this.server.setUserName(username);
            if (StringUtils.isNotBlank(password)) {
                this.server.login(password);
            }
            this.client = this.server.getClient(clientId);
            this.server.setCurrentClient(this.client);
        }
        catch (URISyntaxException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    private void initServerWithTrust(String hostAddress, Properties props) throws P4JavaException, URISyntaxException {
        boolean isSsl = this.isSslHostAddress(hostAddress);
        IServerAddress.Protocol protocol = isSsl ? IServerAddress.Protocol.P4JAVASSL : IServerAddress.Protocol.P4JAVA;
        this.server = ServerFactory.getOptionsServer(protocol.toString() + "://" + this.stripSslPrefixIfExist(hostAddress), props);
        if (isSsl) {
            this.server.addTrust(new TrustOptions().setAutoAccept(true).setForce(true));
        }
    }

    private boolean isSslHostAddress(String hostAddress) {
        return hostAddress.substring(0, hostAddress.indexOf(":")).toLowerCase().equals("ssl");
    }

    private String stripSslPrefixIfExist(String hostAddress) {
        if (StringUtils.startsWith(hostAddress, "ssl:")) {
            return StringUtils.substring(hostAddress, 4);
        }
        return hostAddress;
    }

    public int createNewChangeList() throws IOException {
        try {
            ChangelistSummary summary = new ChangelistSummary(-1, this.client.getName(), this.server.getUserName(), ChangelistStatus.NEW, new Date(), "Artifactory release plugin", false);
            IChangelist newChangeList = new Changelist((IChangelistSummary)summary, this.server, false);
            newChangeList = this.client.createChangelist(newChangeList);
            newChangeList.update();
            return newChangeList.getId();
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void editFile(int changeListId, File file) throws IOException {
        try {
            List<IFileSpec> fileSpecs = FileSpecBuilder.makeFileSpecList(file.getAbsolutePath());
            List<IFileSpec> fileSpecsResult = this.client.editFiles(fileSpecs, false, false, changeListId, null);
            for (IFileSpec fileSpec : fileSpecsResult) {
                FileSpecOpStatus status = fileSpec.getOpStatus();
                if (FileSpecOpStatus.VALID.equals((Object)status) || FileSpecOpStatus.INFO.equals((Object)status)) continue;
                String statusMessage = fileSpec.getStatusMessage();
                throw new IOException("Failed opening file for editing: : '" + statusMessage + "'");
            }
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void commitWorkingCopy(int changeListId, String commitMessage) throws IOException {
        try {
            IChangelist changelist = this.server.getChangelist(changeListId);
            changelist.setDescription(commitMessage);
            changelist.getFiles(true);
            SubmitOptions submitOptions = new SubmitOptions("-f revertunchanged");
            changelist.submit(submitOptions);
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void createLabel(String labelName, String description, String changeListId) throws IOException {
        try {
            if (this.server.getLabel(labelName) != null) {
                throw new IOException("Failed to create label '" + labelName + "', label already exists");
            }
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
        ViewMap<ILabelMapping> viewMapping = new ViewMap<ILabelMapping>();
        ClientView clientView = this.client.getClientView();
        if (clientView != null) {
            for (IClientViewMapping clientViewMapping : clientView) {
                Label.LabelMapping mapping = new Label.LabelMapping();
                mapping.setLeft(clientViewMapping.getDepotSpec());
                mapping.setViewMapping(clientViewMapping.getDepotSpec());
                viewMapping.addEntry(mapping);
            }
        }
        Date now = new Date();
        Label label = new Label(labelName, this.client.getOwnerName(), now, now, description, "@" + changeListId, false, viewMapping);
        try {
            this.server.createLabel(label);
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void deleteLabel(String labelName) throws IOException {
        try {
            this.server.deleteLabel(labelName, false);
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void revertWorkingCopy(int changeListId) throws IOException {
        try {
            IChangelist changelist = this.server.getChangelist(changeListId);
            this.client.revertFiles(changelist.getFiles(true), false, changeListId, false, false);
            this.deleteChangeList(changeListId);
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public int getDefaultChangeListId() throws IOException {
        try {
            IChangelist defaultChangeList = this.server.getChangelist(0);
            return defaultChangeList.getId();
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void deleteChangeList(int changeListId) throws IOException {
        try {
            if (changeListId != 0 && !ChangelistStatus.SUBMITTED.equals((Object)this.server.getChangelist(changeListId).getStatus())) {
                this.server.deletePendingChangelist(changeListId);
            }
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public void closeConnection() throws IOException {
        try {
            this.server.disconnect();
        }
        catch (P4JavaException e) {
            throw new IOException("Perforce execution failed: '" + e.getMessage() + "'", e);
        }
    }

    public static class Builder
    implements Serializable {
        private String hostAddress;
        private String username;
        private String password;
        private String clientId;
        private String charset;

        public PerforceClient build() throws IOException {
            if (StringUtils.isBlank(this.clientId)) {
                throw new IllegalStateException("Client clientId cannot be empty");
            }
            if (StringUtils.isBlank(this.hostAddress)) {
                throw new IllegalStateException("Hostname cannot be empty");
            }
            return new PerforceClient(this.hostAddress, this.clientId, this.username, this.password, this.charset);
        }

        public Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public Builder client(String client) {
            this.clientId = client;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }
    }
}

