/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.npm.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.npm.types.NpmPackageInfo;
import org.jfrog.build.extractor.npm.types.NpmScope;
import org.jfrog.build.extractor.scan.DependencyTree;
import org.jfrog.build.extractor.scan.Scope;

public class NpmDependencyTree {
    public static DependencyTree createDependencyTree(JsonNode npmList, NpmScope scope, Path workingDir) {
        DependencyTree rootNode = new DependencyTree();
        NpmDependencyTree.populateDependenciesTree(rootNode, npmList.get("dependencies"), new String[]{NpmDependencyTree.getProjectName(npmList, workingDir)}, scope);
        for (TreeNode treeNode : rootNode.getChildren()) {
            DependencyTree dependencyTree = (DependencyTree)treeNode;
            NpmPackageInfo packageInfo = (NpmPackageInfo)dependencyTree.getUserObject();
            dependencyTree.setScopes(NpmDependencyTree.getScopes(packageInfo.getName(), packageInfo.getScope()));
        }
        return rootNode;
    }

    static String getProjectName(JsonNode npmList, Path workingDir) {
        JsonNode name = npmList.get("name");
        JsonNode version = npmList.get("version");
        if (name != null) {
            if (version != null) {
                return name.asText() + ":" + version.asText();
            }
            return name.asText();
        }
        return workingDir.getFileName().toString();
    }

    private static void populateDependenciesTree(DependencyTree scanTreeNode, JsonNode dependencies, String[] pathToRoot, NpmScope scope) {
        if (dependencies == null || pathToRoot == null) {
            return;
        }
        dependencies.fields().forEachRemaining(stringJsonNodeEntry -> {
            String name = (String)stringJsonNodeEntry.getKey();
            JsonNode versionNode = ((JsonNode)stringJsonNodeEntry.getValue()).get("version");
            if (versionNode != null) {
                NpmDependencyTree.addSubtree(stringJsonNodeEntry, scanTreeNode, name, versionNode.asText(), pathToRoot, scope);
            }
        });
    }

    private static void addSubtree(Map.Entry<String, JsonNode> stringJsonNodeEntry, DependencyTree node, String name, String version, String[] pathToRoot, NpmScope scope) {
        JsonNode jsonNode = stringJsonNodeEntry.getValue();
        String devScope = scope.toString();
        NpmPackageInfo npmPackageInfo = new NpmPackageInfo(name, version, devScope, pathToRoot);
        JsonNode childDependencies = jsonNode.get("dependencies");
        DependencyTree childTreeNode = new DependencyTree(npmPackageInfo);
        NpmDependencyTree.populateDependenciesTree(childTreeNode, childDependencies, ArrayUtils.insert(0, pathToRoot, npmPackageInfo.toString()), scope);
        node.add(childTreeNode);
    }

    private static Set<Scope> getScopes(String name, String devScope) {
        HashSet<Scope> scopes = new HashSet<Scope>();
        scopes.add(new Scope(devScope));
        String customScope = StringUtils.substringBetween(name, "@", "/");
        if (customScope != null) {
            scopes.add(new Scope(customScope));
        }
        return scopes;
    }
}

