/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.filespecs.aql.AqlConverter;
import org.jfrog.filespecs.entities.Aql;
import org.jfrog.filespecs.entities.FilesGroup;

public class AqlHelper {
    protected static final String LATEST = "LATEST";
    protected static final String LAST_RELEASE = "LAST_RELEASE";
    protected static final String DELIMITER = "/";
    protected static final String ESCAPE_CHAR = "\\";
    protected Log log;
    protected ArtifactoryManager artifactoryManager;
    protected String buildName;
    protected String buildNumber;
    protected final FilesGroup filesGroup;

    AqlHelper(ArtifactoryManager artifactoryManager, Log log, FilesGroup file) throws IOException {
        this.artifactoryManager = artifactoryManager;
        this.log = log;
        this.filesGroup = file;
        this.buildQueryAdditionalParts();
    }

    private void buildQueryAdditionalParts() throws IOException {
        this.buildName = AqlHelper.getBuildName(this.filesGroup.getBuild());
        this.buildNumber = this.getBuildNumber(this.artifactoryManager, this.buildName, this.filesGroup.getBuild(), null);
    }

    public List<AqlSearchResult.SearchEntry> run() throws IOException {
        String aql;
        if (this.filesGroup.getSpecType() == FilesGroup.SpecType.BUILD) {
            String queryBody = AqlHelper.createAqlBodyForBuild(this.buildName, this.buildNumber);
            Aql query = new Aql();
            query.setFind(queryBody);
            this.filesGroup.setAql(query);
            aql = AqlConverter.convertFilesGroupToAql(this.filesGroup);
            this.filesGroup.setAql(null);
        } else {
            aql = AqlConverter.convertFilesGroupToAql(this.filesGroup);
        }
        this.log.debug("Searching Artifactory using AQL query:\n" + aql);
        AqlSearchResult aqlSearchResult = this.artifactoryManager.searchArtifactsByAql(aql);
        List<AqlSearchResult.SearchEntry> queryResults = aqlSearchResult.getResults();
        List<AqlSearchResult.SearchEntry> artifactsSha1SearchResults = this.filesGroup.getSpecType() == FilesGroup.SpecType.BUILD ? queryResults : (!StringUtils.isBlank(this.buildName) && !StringUtils.isBlank(this.buildNumber) ? this.fetchBuildArtifactsSha1() : new ArrayList<AqlSearchResult.SearchEntry>());
        ArrayList results = this.filterResult(queryResults, artifactsSha1SearchResults);
        return results == null ? new ArrayList() : results;
    }

    private List<AqlSearchResult.SearchEntry> filterResult(List<AqlSearchResult.SearchEntry> queryResults, List<AqlSearchResult.SearchEntry> artifactsSha1SerachResults) throws IOException {
        if (StringUtils.isNotBlank(this.buildName) && queryResults.size() > 0) {
            Map<String, Boolean> buildArtifactsSha1 = AqlHelper.extractSha1FromAqlResponse(artifactsSha1SerachResults);
            queryResults = AqlHelper.filterAqlSearchResultsByBuild(queryResults, buildArtifactsSha1, this.buildName, this.buildNumber);
        }
        return queryResults;
    }

    private List<AqlSearchResult.SearchEntry> fetchBuildArtifactsSha1() throws IOException {
        String includeSha1Field = ".include(\"name\",\"repo\",\"path\",\"actual_sha1\")";
        String buildAql = String.format("items.find(%s)%s", AqlHelper.createAqlBodyForBuild(this.buildName, this.buildNumber), includeSha1Field);
        this.log.debug("Searching Artifactory for build's checksums using AQL query:\n" + buildAql);
        AqlSearchResult aqlSearchResult = this.artifactoryManager.searchArtifactsByAql(buildAql);
        return aqlSearchResult.getResults();
    }

    private static String createAqlBodyForBuild(String buildName, String buildNumber) {
        return String.format("{\"artifact.module.build.name\": \"%s\",\"artifact.module.build.number\": \"%s\"}", buildName, buildNumber);
    }

    private static String getBuildName(String build) {
        if (StringUtils.isBlank(build)) {
            return build;
        }
        String buildName = StringUtils.substringBeforeLast(build, DELIMITER);
        while (StringUtils.isNotBlank(buildName) && buildName.contains(DELIMITER) && buildName.endsWith(ESCAPE_CHAR)) {
            buildName = StringUtils.substringBeforeLast(buildName, DELIMITER);
        }
        return buildName.endsWith(ESCAPE_CHAR) ? build : buildName;
    }

    private String getBuildNumber(ArtifactoryManager client, String buildName, String build, String project) throws IOException {
        String buildNumber = "";
        if (StringUtils.isNotBlank(buildName)) {
            if (!build.startsWith(buildName)) {
                throw new IllegalStateException(String.format("build '%s' does not start with build name '%s'.", build, buildName));
            }
            if (build.equals(buildName)) {
                buildNumber = LATEST;
            } else {
                buildNumber = build.substring(buildName.length() + DELIMITER.length());
                buildNumber = buildNumber.replace("\\/", DELIMITER);
            }
            String retrievedBuildNumber = client.getLatestBuildNumber(buildName, buildNumber, project);
            if (retrievedBuildNumber == null) {
                this.logBuildNotFound(buildName, buildNumber);
            }
            buildNumber = retrievedBuildNumber;
        }
        return buildNumber;
    }

    private void logBuildNotFound(String buildName, String buildNumber) {
        StringBuilder sb = new StringBuilder("The build name ").append(buildName);
        if (LAST_RELEASE.equals(buildNumber.trim())) {
            sb.append(" with the status RELEASED");
        }
        sb.append(" could not be found.");
        this.log.warn(sb.toString());
    }

    private static List<AqlSearchResult.SearchEntry> filterAqlSearchResultsByBuild(List<AqlSearchResult.SearchEntry> itemsToFilter, Map<String, Boolean> buildArtifactsSha1, String buildName, String buildNumber) {
        HashMap<String, List<AqlSearchResult.SearchEntry>> firstPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        HashMap<String, List<AqlSearchResult.SearchEntry>> secondPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        HashMap<String, List<AqlSearchResult.SearchEntry>> thirdPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        ArrayList<AqlSearchResult.SearchEntry> filteredResults = new ArrayList<AqlSearchResult.SearchEntry>();
        for (AqlSearchResult.SearchEntry searchEntry : itemsToFilter) {
            if (!buildArtifactsSha1.containsKey(searchEntry.getActualSha1())) continue;
            boolean isBuildNameMatch = buildName.equals(searchEntry.getBuildName());
            boolean isBuildNumberMatch = buildNumber.equals(searchEntry.getBuildNumber());
            if (isBuildNameMatch) {
                if (isBuildNumberMatch) {
                    AqlHelper.addToListInMap(firstPriority, searchEntry);
                    continue;
                }
                AqlHelper.addToListInMap(secondPriority, searchEntry);
                continue;
            }
            AqlHelper.addToListInMap(thirdPriority, searchEntry);
        }
        for (Map.Entry entry : buildArtifactsSha1.entrySet()) {
            String shaToMatch = (String)entry.getKey();
            if (firstPriority.containsKey(shaToMatch)) {
                filteredResults.addAll((Collection)firstPriority.get(shaToMatch));
                continue;
            }
            if (secondPriority.containsKey(shaToMatch)) {
                filteredResults.addAll((Collection)secondPriority.get(shaToMatch));
                continue;
            }
            if (!thirdPriority.containsKey(shaToMatch)) continue;
            filteredResults.addAll((Collection)thirdPriority.get(shaToMatch));
        }
        return filteredResults;
    }

    private static void addToListInMap(Map<String, List<AqlSearchResult.SearchEntry>> map, AqlSearchResult.SearchEntry item) {
        List<AqlSearchResult.SearchEntry> curList = map.get(item.getActualSha1());
        if (curList == null) {
            curList = new ArrayList<AqlSearchResult.SearchEntry>();
        }
        curList.add(item);
        map.put(item.getActualSha1(), curList);
    }

    private static Map<String, Boolean> extractSha1FromAqlResponse(List<AqlSearchResult.SearchEntry> searchResults) {
        HashMap<String, Boolean> resultsMap = new HashMap<String, Boolean>();
        searchResults.forEach(result -> resultsMap.put(result.getActualSha1(), true));
        return resultsMap;
    }
}

