/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.PreemptiveHttpClientBuilder;
import org.jfrog.build.client.ProxyConfiguration;

public class JFrogHttpClient
implements AutoCloseable {
    public static final ArtifactoryVersion STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION = new ArtifactoryVersion("5.2.1");
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    public static final int DEFAULT_CONNECTION_RETRY = 3;
    private final String url;
    private final PreemptiveHttpClientBuilder clientBuilder;
    private PreemptiveHttpClient deployClient;
    private Log log;

    private JFrogHttpClient(String url, String username, String password, String accessToken, Log log) {
        this.url = StringUtils.removeEnd(url, "/");
        this.log = log;
        this.clientBuilder = new PreemptiveHttpClientBuilder().setConnectionRetries(3).setInsecureTls(false).setTimeout(300).setLog(log);
        if (StringUtils.isNotEmpty(accessToken)) {
            this.clientBuilder.setAccessToken(accessToken);
        } else {
            this.clientBuilder.setUserName(username).setPassword(password);
        }
    }

    public JFrogHttpClient(String artifactoryUrl, String username, String password, Log log) {
        this(artifactoryUrl, username, password, "", log);
    }

    public JFrogHttpClient(String artifactoryUrl, String accessToken, Log log) {
        this(artifactoryUrl, "", "", accessToken, log);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.host = host;
        proxyConfiguration.port = port;
        proxyConfiguration.username = username;
        proxyConfiguration.password = password;
        this.clientBuilder.setProxyConfiguration(proxyConfiguration);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.clientBuilder.setTimeout(connectionTimeout);
    }

    public void setInsecureTls(boolean insecureTls) {
        this.clientBuilder.setInsecureTls(insecureTls);
    }

    public void setSslContext(SSLContext sslContext) {
        this.clientBuilder.setSslContext(sslContext);
    }

    public int getConnectionRetries() {
        return this.clientBuilder.connectionRetries;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.clientBuilder.setConnectionRetries(connectionRetries);
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.clientBuilder.getProxyConfiguration();
    }

    @Override
    public void close() {
        if (this.deployClient != null) {
            this.deployClient.close();
        }
    }

    public PreemptiveHttpClient getHttpClient() {
        if (this.deployClient == null) {
            this.deployClient = this.clientBuilder.build();
        }
        return this.deployClient;
    }

    public CloseableHttpResponse sendRequest(HttpRequestBase request) throws IOException {
        this.log.debug("Base URL: " + request.getURI().toString());
        PreemptiveHttpClient client = this.getHttpClient();
        String url = request.getURI().toString();
        request.setURI(URI.create(this.url + "/" + StringUtils.removeStart(url, "/")));
        return client.execute(request);
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public String getUrl() {
        return this.url;
    }
}

