/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="buildagent")
public class BuildAgent
implements Serializable {
    private String name;
    private String version;

    public BuildAgent() {
    }

    public BuildAgent(String agent) {
        int slash = agent.indexOf(47);
        if (slash != -1 && slash < agent.length() - 1) {
            this.name = agent.substring(0, slash);
            this.version = agent.substring(slash + 1);
        } else {
            this.name = agent;
        }
    }

    public BuildAgent(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.name)) {
            toStringBuilder.append(this.name);
        }
        if (StringUtils.isNotBlank(this.version)) {
            if (toStringBuilder.length() > 0) {
                toStringBuilder.append("/");
            }
            toStringBuilder.append(this.version);
        }
        return toStringBuilder.toString();
    }
}

