/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.util;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.types.Commandline;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.ProxyUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;

public class TaskUtils {
    private static final int MAX_BUILD_DATA_SIZE = 2047;

    public static Map<String, String> getEscapedEnvMap(Map<String, String> env) {
        HashMap<String, String> result = Maps.newHashMap();
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String escaped = entry.getKey().replace('_', '.');
                escaped = StringUtils.removeStart(escaped, "bamboo.");
                result.put(escaped, entry.getValue());
            }
        }
        return result;
    }

    public static void appendBuildInfoPropertiesArgument(List<String> arguments, String buildInfoPropertiesFile) {
        if (arguments != null && StringUtils.isNotBlank(buildInfoPropertiesFile)) {
            arguments.add(Commandline.quoteArgument("-DbuildInfoConfig.propertiesFile=" + buildInfoPropertiesFile));
        }
    }

    public static ServerConfig getResolutionServerConfig(String baseUsername, String basePassword, ServerConfigManager serverConfigManager, ServerConfig serverConfig, BuildParamsOverrideManager buildParamsOverrideManager) {
        return TaskUtils.getRequestedServerConfig(baseUsername, basePassword, serverConfigManager, serverConfig, buildParamsOverrideManager, "artifactory.override.resolver.url", "artifactory.override.resolver.username", "artifactory.override.resolver.password");
    }

    public static ServerConfig getDeploymentServerConfig(String baseUsername, String basePassword, ServerConfigManager serverConfigManager, ServerConfig serverConfig, BuildParamsOverrideManager buildParamsOverrideManager) {
        return TaskUtils.getRequestedServerConfig(baseUsername, basePassword, serverConfigManager, serverConfig, buildParamsOverrideManager, "artifactory.override.deployer.url", "artifactory.override.deployer.username", "artifactory.override.deployer.password");
    }

    private static ServerConfig getRequestedServerConfig(String baseUsername, String basePassword, ServerConfigManager serverConfigManager, ServerConfig serverConfig, BuildParamsOverrideManager buildParamsOverrideManager, String overrideUrlKey, String overrideUsernameKey, String overridePasswordKey) {
        String password;
        if (serverConfig == null) {
            return null;
        }
        String username = TaskUtils.overrideParam(serverConfigManager.substituteVariables(baseUsername), overrideUsernameKey, buildParamsOverrideManager);
        if (StringUtils.isBlank(username)) {
            username = serverConfigManager.substituteVariables(serverConfig.getUsername());
        }
        if (StringUtils.isBlank(password = TaskUtils.overrideParam(serverConfigManager.substituteVariables(basePassword), overridePasswordKey, buildParamsOverrideManager))) {
            password = serverConfigManager.substituteVariables(serverConfig.getPassword());
        }
        String serverUrl = TaskUtils.overrideParam(serverConfigManager.substituteVariables(serverConfig.getUrl()), overrideUrlKey, buildParamsOverrideManager);
        return new ServerConfig(serverConfig.getId(), serverUrl, username, password, serverConfig.getTimeout());
    }

    public static ArtifactoryManagerBuilder getArtifactoryManagerBuilderBuilder(ServerConfig serverConfig, Log log) {
        ArtifactoryManagerBuilder artifactoryManagerBuilder = new ArtifactoryManagerBuilder();
        ((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)artifactoryManagerBuilder.setServerUrl(serverConfig.getUrl())).setUsername(serverConfig.getUsername())).setPassword(serverConfig.getPassword())).setLog(log)).setConnectionTimeout(serverConfig.getTimeout());
        ProxyUtils.setProxyConfig(serverConfig.getUrl(), artifactoryManagerBuilder);
        return artifactoryManagerBuilder;
    }

    private static String overrideParam(String originalValue, String overrideKey, BuildParamsOverrideManager buildParamsOverrideManager) {
        String overriddenValue = buildParamsOverrideManager.getOverrideValue(overrideKey);
        return overriddenValue.isEmpty() ? originalValue : overriddenValue;
    }

    public static File getVcsWorkingDirectory(TaskContext taskContext) {
        File checkoutDir = VcsHelper.getCheckoutDirectory(taskContext.getBuildContext());
        if (checkoutDir != null) {
            return checkoutDir;
        }
        return taskContext.getWorkingDirectory();
    }

    public static BuildInfo getBuildObjectFromBuildInfoFile(String buildInfoFilePath) throws IOException {
        if (StringUtils.isBlank(buildInfoFilePath)) {
            throw new IllegalArgumentException("Provided empty build-info file path.");
        }
        Path generatedBuildInfoPath = Paths.get(buildInfoFilePath, new String[0]);
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(generatedBuildInfoPath, StandardCharsets.UTF_8);){
            stream.forEach(s2 -> contentBuilder.append((String)s2).append("\n"));
        }
        generatedBuildInfoPath.toFile().delete();
        String buildInfoJson = contentBuilder.toString();
        if (StringUtils.isBlank(buildInfoJson)) {
            return null;
        }
        return BuildInfoExtractorUtils.jsonStringToBuildInfo(buildInfoJson);
    }

    private static List<String> splitBuildDataToChunks(String buildData) {
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < buildData.length(); i += 2047) {
            chunks.add(buildData.substring(i, Math.min(buildData.length(), i + 2047)));
        }
        return chunks;
    }

    public static void addBuildInfoToContext(TaskContext taskContext, String buildInfo) {
        Map customBuildData = taskContext.getBuildContext().getParentBuildContext().getBuildResult().getCustomBuildData();
        List<String> chunks = TaskUtils.splitBuildDataToChunks(buildInfo);
        for (int i = 0; i < chunks.size(); ++i) {
            customBuildData.put("org.jfrog.bamboo.aggregatedBuildInfoJson." + i, chunks.get(i));
        }
    }

    public static String getAndDeleteAggregatedBuildInfo(TaskContext taskContext) {
        Map customBuildData = taskContext.getBuildContext().getParentBuildContext().getBuildResult().getCustomBuildData();
        List chunks = customBuildData.entrySet().stream().filter(stringStringEntry -> ((String)stringStringEntry.getKey()).startsWith("org.jfrog.bamboo.aggregatedBuildInfoJson.")).sorted(Comparator.comparingInt(entry -> Integer.parseInt(StringUtils.substringAfterLast((String)entry.getKey(), ".")))).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry chunk : chunks) {
            stringBuilder.append((String)chunk.getValue());
            customBuildData.remove(chunk.getKey());
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> addExecutablePathToEnv(Map<String, String> env, PackageManagersContext buildContext, CapabilityContext capabilityContext, String builderKey, String executableName, String taskName, boolean containerized) throws TaskException {
        String executablePath = TaskUtils.getExecutablePath(buildContext, capabilityContext, builderKey, executableName, taskName, containerized);
        String path = env.get("PATH");
        path = SystemUtils.IS_OS_WINDOWS && !containerized ? executablePath + ";" + path : executablePath + ":" + path;
        env.put("PATH", path);
        return env;
    }

    public static String getExecutablePath(PackageManagersContext buildContext, CapabilityContext capabilityContext, String builderKey, String executableName, String taskName, boolean containerized) throws TaskException {
        ReadOnlyCapabilitySet capabilitySet = capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            return null;
        }
        Capability capability = capabilitySet.getCapability(builderKey + buildContext.getExecutable());
        if (capability == null || StringUtils.isEmpty(capability.getValue())) {
            throw new TaskException(taskName + " capability: " + buildContext.getExecutable() + " is not defined, please check job configuration");
        }
        if (containerized) {
            return capability.getValue();
        }
        String path = Paths.get(capability.getValue(), "bin", executableName).toString();
        if (!new File(path).exists() && !new File(path = Paths.get(capability.getValue(), new String[0]).toString()).exists()) {
            throw new TaskException("Executable '" + executableName + "'  does not exist at path '" + path + "'");
        }
        return path;
    }

    public static Map<String, String> getEnvironmentVariables(PackageManagersContext buildContext, EnvironmentVariableAccessor environmentVariableAccessor) {
        HashMap<String, String> env = Maps.newHashMap();
        env.putAll(environmentVariableAccessor.getEnvironment());
        if (StringUtils.isNotBlank(buildContext.getEnvironmentVariables())) {
            env.putAll(environmentVariableAccessor.splitEnvironmentAssignments(buildContext.getEnvironmentVariables(), false));
        }
        return env;
    }

    public static ArrayListMultimap<String, String> getCommonArtifactPropertiesMap(BuildInfoHelper buildInfoHelper) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        buildInfoHelper.addCommonProperties(propertiesMap);
        return ArrayListMultimap.create(Multimaps.forMap(propertiesMap));
    }

    public static File getBambooTmp(CustomVariableContext customVariableContext) {
        return new File(((VariableDefinitionContext)customVariableContext.getVariableContexts().get("tmp.directory")).getValue());
    }

    public static String getPlanKey(CustomVariableContext customVariableContext) {
        return ((VariableDefinitionContext)customVariableContext.getVariableContexts().get("planKey")).getValue();
    }
}

