/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.builder.MavenAndIvyBuildInfoDataHelperBase;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.TaskUtils;

public abstract class BaseJavaBuildTask
extends ArtifactoryTaskType {
    protected static final String JDK_LABEL_KEY = "system.jdk.";
    public static final String JAVA_HOME = "JAVA_HOME";
    protected Map<String, String> environmentVariables;
    protected final EnvironmentVariableAccessor environmentVariableAccessor;
    private final TestCollationService testCollationService;
    protected BuildParamsOverrideManager buildParamsOverrideManager;
    protected CustomVariableContext customVariableContext;
    private final ProcessService processService;
    String buildInfoPropertiesFile;
    boolean activateBuildInfoRecording;
    boolean aggregateBuildInfo;
    final File bambooTmp;

    protected BaseJavaBuildTask(TestCollationService testCollationService, EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService) {
        ContainerManager.autowireComponent((Object)this);
        this.testCollationService = testCollationService;
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        this.bambooTmp = TaskUtils.getBambooTmp(this.customVariableContext);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    void initEnvironmentVariables(PackageManagersContext buildContext) {
        this.environmentVariables = TaskUtils.getEnvironmentVariables(buildContext, this.environmentVariableAccessor);
    }

    public TaskResult collectTestResults(PackageManagersContext buildContext, TaskContext taskContext, ExternalProcess process) {
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(process);
        if (buildContext.isTestChecked() && buildContext.getTestDirectory() != null) {
            this.testCollationService.collateTestResults(taskContext, buildContext.getTestDirectory());
            builder.checkTestFailures();
        }
        return builder.build();
    }

    protected String getConfiguredJdkPath(BuildParamsOverrideManager buildParamsOverrideManager, PackageManagersContext context, CapabilityContext capabilityContext) {
        if (this.shouldOverrideJdk()) {
            String envVarValue;
            String jdkEnvVarName = buildParamsOverrideManager.getOverrideValue("artifactory.task.override.jdk.env.var");
            if (StringUtils.isEmpty((String)jdkEnvVarName)) {
                jdkEnvVarName = JAVA_HOME;
            }
            if ((envVarValue = this.environmentVariables.get(jdkEnvVarName)) == null) {
                throw new RuntimeException("The task is configured to use the '" + jdkEnvVarName + "' environment variable for the build JDK, but this environment variable is not defined.");
            }
            return this.getPathBuilder(envVarValue).toString();
        }
        String jdkCapabilityKey = JDK_LABEL_KEY + context.getJdkLabel();
        ReadOnlyCapabilitySet capabilitySet = capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            return null;
        }
        Capability capability = capabilitySet.getCapability(jdkCapabilityKey);
        if (capability == null) {
            return null;
        }
        String jdkHome = capability.getValue();
        if (StringUtils.isBlank((String)jdkHome)) {
            return null;
        }
        StringBuilder binPathBuilder = this.getPathBuilder(jdkHome);
        return binPathBuilder.toString();
    }

    public StringBuilder getPathBuilder(String basePath) {
        StringBuilder confPathBuilder = new StringBuilder(basePath);
        if (!basePath.endsWith(this.fileSeparator)) {
            confPathBuilder.append(this.fileSeparator);
        }
        return confPathBuilder;
    }

    public String getCanonicalPath(String path) {
        if (StringUtils.contains((String)path, (String)" ")) {
            try {
                File f = new File(path);
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("IO Exception trying to get canonical path of item: " + path, e);
            }
        }
        return path;
    }

    public String getErrorMessage(ExternalProcess process) {
        StringOutputHandler errorStringHandler;
        OutputHandler errorHandler;
        ProcessHandler handler = process.getHandler();
        String commandLine = process.getCommandLine();
        StringBuilder message = new StringBuilder();
        if (handler.getException() != null) {
            message.append("Exception executing command \"").append(commandLine).append(" \n").append(handler.getException().getMessage()).append("\n").append(handler.getException()).append("\n");
        }
        String reason = null;
        if (handler instanceof PluggableProcessHandler && (errorHandler = ((PluggableProcessHandler)handler).getErrorHandler()) instanceof StringOutputHandler && (errorStringHandler = (StringOutputHandler)errorHandler).getOutput() != null) {
            reason = errorStringHandler.getOutput();
        }
        if (reason != null && reason.trim().length() > 0) {
            message.append("Error executing command \"").append(commandLine).append("\": ").append(reason);
        }
        return message.toString();
    }

    private boolean shouldOverrideJdk() {
        return Boolean.valueOf(this.buildParamsOverrideManager.getOverrideValue("artifactory.task.override.jdk"));
    }

    @NotNull
    ExternalProcess getExternalProcess(@NotNull TaskContext taskContext, File rootDirectory, List<String> command, Map<String, String> environmentVariables) {
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().workingDirectory(rootDirectory).command(command).env(environmentVariables);
        return this.processService.createExternalProcess((CommonTaskContext)taskContext, processBuilder);
    }

    void executeExternalProcess(BuildLogger logger, ExternalProcess process, Logger log) {
        process.execute();
        if (process.getHandler() != null && !process.getHandler().succeeded()) {
            String externalProcessOutput = this.getErrorMessage(process);
            logger.addBuildLogEntry(externalProcessOutput);
            log.debug("Process command error: " + externalProcessOutput);
        }
    }

    void convertGeneratedBuildInfoToBuild() throws TaskException {
        String generatedBuildInfo = this.environmentVariables.get("generated.build.info");
        try {
            this.taskBuildInfo = TaskUtils.getBuildObjectFromBuildInfoFile(generatedBuildInfo);
        }
        catch (Exception ex) {
            throw new TaskException("Failed to add Build Info to context.", (Throwable)ex);
        }
    }

    @NotNull
    Map<String, String> getCombinedConfiguration(CommonTaskContext context) {
        HashMap<String, String> combinedMap = Maps.newHashMap();
        combinedMap.putAll((Map<String, String>)context.getConfigurationMap());
        BuildContext parentBuildContext = ((TaskContext)context).getBuildContext().getParentBuildContext();
        if (parentBuildContext != null) {
            Map customBuildData = parentBuildContext.getBuildResult().getCustomBuildData();
            combinedMap.putAll(customBuildData);
        }
        return combinedMap;
    }

    void createBuildInfoFiles(boolean shouldCaptureBuildInfo, MavenAndIvyBuildInfoDataHelperBase dataHelper) throws TaskException {
        try {
            if (shouldCaptureBuildInfo) {
                String buildInfoJsonPath = dataHelper.createBuildInfoJSonFileAndGetItsPath(this.bambooTmp);
                this.environmentVariables.put("generated.build.info", buildInfoJsonPath);
            }
            this.buildInfoPropertiesFile = dataHelper.createBuildInfoPropsFileAndGetItsPath(shouldCaptureBuildInfo, this.bambooTmp);
        }
        catch (IOException e) {
            throw new TaskException("Failed to create Build Info properties file.", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)this.buildInfoPropertiesFile)) {
            this.activateBuildInfoRecording = true;
        }
    }
}

