/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.usageReport.UsageReporter;

public abstract class ArtifactoryTaskBase {
    protected static final Logger log = LogManager.getLogger(ArtifactoryTaskBase.class);
    protected PluginAccessor pluginAccessor;
    protected CommonTaskContext taskContext;
    protected boolean containerized;
    protected String fileSeparator;
    protected BuildLogger logger;
    protected Log buildInfoLog;

    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        this.taskContext = context;
        this.logger = this.taskContext.getBuildLogger();
        this.buildInfoLog = new BuildInfoLog(log, this.logger);
        this.containerized = this.taskContext.getCommonContext().getDockerPipelineConfiguration().isEnabled();
        this.fileSeparator = this.containerized ? "/" : File.separator;
    }

    protected abstract ServerConfig getUsageServerConfig();

    protected abstract String getTaskUsageName();

    protected void reportUsage(ServerConfig serverConfig, String taskName, Log log) {
        String[] featureIdArray = new String[]{taskName};
        UsageReporter usageReporter = new UsageReporter("bamboo-artifactory-plugin/" + Utils.getPluginVersion(this.pluginAccessor), featureIdArray);
        try {
            usageReporter.reportUsage(serverConfig.getUrl(), serverConfig.getUsername(), serverConfig.getPassword(), "", null, log);
            log.info("Usage info sent successfully.");
        }
        catch (Exception ex) {
            log.info("Failed sending usage report to Artifactory: " + ex);
        }
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

