/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.FileSpecUtils;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.PublishedItemsHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryGenericDeployTask
extends ArtifactoryTaskType {
    public static final String TASK_NAME = "artifactoryGenericTask";
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final BuildParamsOverrideManager buildParamsOverrideManager;
    private CustomVariableContext customVariableContext;
    private BuildInfoHelper buildInfoHelper;
    private GenericContext genericContext;
    private BuildContext buildContext;
    private String fileSpec;

    public ArtifactoryGenericDeployTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
        this.buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
    }

    @Override
    public void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.buildContext = ((TaskContext)this.taskContext).getBuildContext();
        this.genericContext = new GenericContext((Map<String, String>)this.taskContext.getConfigurationMap());
        Map runtimeContext = context.getRuntimeTaskContext();
        this.buildInfoHelper = BuildInfoHelper.createDeployBuildInfoHelper(this.genericContext.getBuildName(this.buildContext), this.genericContext.getBuildNumber(this.buildContext), this.taskContext, this.buildContext, this.environmentVariableAccessor, this.genericContext.getSelectedServerId(), this.genericContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), this.genericContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), this.buildParamsOverrideManager);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + Utils.getPluginVersion(this.pluginAccessor));
        CurrentBuildResult result = this.buildContext.getBuildResult();
        if (result.getBuildState().equals((Object)BuildState.FAILED)) {
            log.error(this.logger.addErrorLogEntry("Build failed, not deploying to Artifactory."));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
        }
        BuildInfo build = this.buildInfoHelper.getBuild(taskContext, this.genericContext);
        ArtifactoryManagerBuilder artifactoryManagerBuilder = this.buildInfoHelper.getClientBuilder(this.logger, log);
        try {
            File workingDirectory = this.getWorkingDirectory();
            if (workingDirectory == null) {
                log.error(this.logger.addErrorLogEntry("No build directory found!"));
                return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
            }
            if (this.genericContext.isUseFileSpecs()) {
                this.initFileSpec();
                build = this.deployByFileSpec(workingDirectory, build, artifactoryManagerBuilder, this.fileSpec);
            } else {
                build = this.deployByLegacyPattern(workingDirectory, build, artifactoryManagerBuilder, this.genericContext);
            }
            List taskDefinitions = taskContext.getBuildContext().getRuntimeTaskDefinitions();
            if (this.genericContext.isCaptureBuildInfo() || this.genericContext.isPublishBuildInfo() && TaskDefinitionHelper.isBuildPublishTaskExists(taskDefinitions)) {
                this.taskBuildInfo = build;
            } else if (this.genericContext.isPublishBuildInfo()) {
                this.publishBuildInfo(taskContext, artifactoryManagerBuilder, build);
            }
        }
        catch (Exception e) {
            String message = "Exception occurred while executing task";
            this.logger.addErrorLogEntry(message, (Throwable)e);
            log.error(message, (Throwable)e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        Map customBuildData = result.getCustomBuildData();
        if (this.genericContext.isPublishBuildInfo() && !customBuildData.containsKey("org.jfrog.bamboo.buildInfo.activated")) {
            customBuildData.put("org.jfrog.bamboo.buildInfo.activated", "true");
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return "generic_deploy";
    }

    private void initFileSpec() throws IOException {
        this.fileSpec = FileSpecUtils.getFileSpec(this.genericContext.isFileSpecInJobConfiguration(), this.genericContext.getJobConfigurationSpec(), this.genericContext.getFilePathSpec(), this.getWorkingDirectory(), this.customVariableContext, this.logger);
        this.logger.addBuildLogEntry("Spec: " + this.fileSpec);
        FileSpecUtils.validateFileSpec(this.fileSpec);
    }

    private File getWorkingDirectory() {
        Iterator checkoutLocationsIterator;
        String checkoutLocation;
        Map checkoutLocations = this.buildContext.getCheckoutLocation();
        if (checkoutLocations.size() == 1 && StringUtils.isNotBlank((String)(checkoutLocation = (String)(checkoutLocationsIterator = checkoutLocations.values().iterator()).next()))) {
            return new File(checkoutLocation);
        }
        return this.taskContext.getWorkingDirectory();
    }

    private Multimap<String, File> buildTargetPathToFiles(File directory, GenericContext context) throws IOException {
        HashMultimap<String, File> result = HashMultimap.create();
        String deployPattern = context.getDeployPattern();
        deployPattern = StringUtils.replace((String)deployPattern, (String)"\r\n", (String)"\n");
        Multimap<String, String> pairs = PublishedItemsHelper.getPublishedItemsPatternPairs(deployPattern = StringUtils.replace((String)deployPattern, (String)",", (String)"\n"));
        if (pairs.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, String> entry : pairs.entries()) {
            Multimap<String, File> filesMap = PublishedItemsHelper.buildPublishingData(directory, entry.getKey(), entry.getValue());
            if (filesMap != null) {
                log.info(this.logger.addBuildLogEntry("For pattern: " + entry.getKey() + " " + filesMap.size() + " artifacts were found"));
                result.putAll(filesMap);
                continue;
            }
            log.warn(this.logger.addBuildLogEntry("For pattern: " + entry.getKey() + " no artifacts were found"));
        }
        return result;
    }

    private BuildInfo deployByLegacyPattern(File sourceCodeDirectory, BuildInfo build, ArtifactoryManagerBuilder artifactoryManagerBuilder, GenericContext context) throws IOException, NoSuchAlgorithmException {
        Multimap<String, File> filesMap = this.buildTargetPathToFiles(sourceCodeDirectory, context);
        HashSet<DeployDetails> details = Sets.newHashSet();
        Map<String, String> dynamicPropertyMap = this.buildInfoHelper.getDynamicPropertyMap(build);
        String repoKey = this.buildInfoHelper.overrideParam(context.getRepoKey(), "artifactory.override.deploy.repo");
        for (Map.Entry<String, File> entry : filesMap.entries()) {
            details.addAll(this.buildDeployDetailsFromFileSet(entry, repoKey, dynamicPropertyMap));
        }
        List<Artifact> artifacts = this.buildInfoHelper.convertDeployDetailsToArtifacts(details);
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            for (DeployDetails detail : details) {
                artifactoryManager.upload(detail);
            }
        }
        return this.buildInfoHelper.addBuildInfoParams(build, artifacts, Lists.newArrayList(), Lists.newArrayList());
    }

    private Set<DeployDetails> buildDeployDetailsFromFileSet(Map.Entry<String, File> fileEntry, String targetRepository, Map<String, String> propertyMap) throws IOException, NoSuchAlgorithmException {
        HashSet<DeployDetails> result = Sets.newHashSet();
        String targetPath = fileEntry.getKey();
        File artifactFile = fileEntry.getValue();
        String path = PublishedItemsHelper.calculateTargetPath(targetPath, artifactFile);
        path = StringUtils.replace((String)path, (String)"//", (String)"/");
        Map<String, String> checksums = FileChecksumCalculator.calculateChecksums(artifactFile, "SHA1", "MD5");
        DeployDetails.Builder deployDetails = new DeployDetails.Builder().file(artifactFile).md5(checksums.get("MD5")).sha1(checksums.get("SHA1")).targetRepository(targetRepository).artifactPath(path);
        deployDetails.addProperties(propertyMap);
        result.add(deployDetails.build());
        return result;
    }

    private BuildInfo deployByFileSpec(File sourceCodeDirectory, BuildInfo build, ArtifactoryManagerBuilder artifactoryManagerBuilder, String spec) throws IOException {
        List<Artifact> artifacts;
        SpecsHelper specsHelper = new SpecsHelper(this.buildInfoLog);
        Map<String, String> buildProperties = this.buildInfoHelper.getDynamicPropertyMap(build);
        this.buildInfoHelper.addCommonProperties(buildProperties);
        try {
            artifacts = specsHelper.uploadArtifactsBySpec(spec, sourceCodeDirectory, buildProperties, artifactoryManagerBuilder);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.buildInfoHelper.addBuildInfoParams(build, artifacts, Lists.newArrayList(), Lists.newArrayList());
    }

    public void publishBuildInfo(TaskContext taskContext, ArtifactoryManagerBuilder artifactoryManagerBuilder, BuildInfo build) throws IOException {
        BuildContext buildContext = taskContext.getBuildContext();
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            artifactoryManager.publishBuildInfo(build, "");
            buildContext.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", artifactoryManager.getUrl());
        }
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

