/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.DeploymentUploadContext;
import org.jfrog.bamboo.task.ArtifactoryDeploymentTaskType;
import org.jfrog.bamboo.util.FileSpecUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.deployment.LegacyDeploymentUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryDeploymentUploadTask
extends ArtifactoryDeploymentTaskType {
    private CustomVariableContext customVariableContext;
    private ServerConfig uploadServerConfig;
    private String fileSpec;

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        Map runtimeContext = context.getRuntimeTaskContext();
        DeploymentUploadContext deploymentUploadContext = new DeploymentUploadContext((Map<String, String>)context.getConfigurationMap());
        ServerConfig selectedServerConfig = this.getSelectedServerConfig(context);
        this.uploadServerConfig = TaskUtils.getResolutionServerConfig(deploymentUploadContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), deploymentUploadContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), ServerConfigManager.getInstance(), selectedServerConfig, new BuildParamsOverrideManager(this.customVariableContext));
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull DeploymentTaskContext deploymentTaskContext) {
        ArtifactoryManagerBuilder clientBuilder = TaskUtils.getArtifactoryManagerBuilderBuilder(this.uploadServerConfig, this.buildInfoLog);
        String artifactsRootDirectory = deploymentTaskContext.getWorkingDirectory().getAbsolutePath();
        try {
            this.initFileSpec((CommonTaskContext)deploymentTaskContext);
            SpecsHelper specsHelper = new SpecsHelper(this.buildInfoLog);
            specsHelper.uploadArtifactsBySpec(this.fileSpec, new File(artifactsRootDirectory), new HashMap<String, String>(), clientBuilder);
            return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).success().build();
        }
        catch (Exception e) {
            this.buildInfoLog.error("Exception occurred while executing deployment task", e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).failedWithError().build();
        }
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.uploadServerConfig;
    }

    @Override
    protected String getTaskUsageName() {
        return "deployment_upload";
    }

    private void initFileSpec(CommonTaskContext context) throws IOException {
        String specSourceChoice = (String)context.getConfigurationMap().get((Object)"artifactory.deployment.specSourceChoice");
        if (StringUtils.isNotBlank((String)specSourceChoice)) {
            this.fileSpec = FileSpecUtils.getFileSpec(this.isFileSpecInJobConfiguration(context), this.getJobConfigurationSpec(context), this.getFilePathSpec(context), context.getWorkingDirectory(), this.customVariableContext, this.logger);
            this.logger.addBuildLogEntry("Spec: " + this.fileSpec);
            FileSpecUtils.validateFileSpec(this.fileSpec);
            return;
        }
        this.logger.addBuildLogEntry("Converting legacy configuration to upload spec");
        this.fileSpec = LegacyDeploymentUtils.buildDeploymentSpec(context);
        this.logger.addBuildLogEntry("Spec: " + this.fileSpec);
        FileSpecUtils.validateFileSpec(this.fileSpec);
    }

    private ServerConfig getSelectedServerConfig(@NotNull CommonTaskContext deploymentTaskContext) {
        ServerConfig serverConfig;
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        String serverId = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactory.deployment.artifactoryServerId");
        if (StringUtils.isBlank((String)serverId)) {
            serverId = (String)deploymentTaskContext.getConfigurationMap().get((Object)"artifactoryServerId");
        }
        if ((serverConfig = serverConfigManager.getServerConfigById(Long.parseLong(serverId))) == null) {
            throw new IllegalArgumentException("Could not find Artifactory server. Please check the Artifactory server in the task configuration.");
        }
        return serverConfig;
    }

    private String getJobConfigurationSpec(CommonTaskContext context) {
        return (String)context.getConfigurationMap().get((Object)"artifactory.deployment.jobConfiguration");
    }

    private String getFilePathSpec(CommonTaskContext context) {
        return (String)context.getConfigurationMap().get((Object)"artifactory.deployment.file");
    }

    private Boolean isFileSpecInJobConfiguration(CommonTaskContext context) {
        return "jobConfiguration".equals(context.getConfigurationMap().get((Object)"artifactory.deployment.specSourceChoice"));
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

