/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.GenericContext;
import org.jfrog.bamboo.task.ArtifactoryDeploymentTaskType;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.FileSpecUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class ArtifactoryDeploymentDownloadTask
extends ArtifactoryDeploymentTaskType {
    private CustomVariableContext customVariableContext;
    private ServerConfig downloadServerConfig;
    private GenericContext genericContext;
    private String fileSpec;

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.genericContext = new GenericContext((Map<String, String>)context.getConfigurationMap());
        BuildParamsOverrideManager buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        this.downloadServerConfig = this.getArtifactoryServerConfig(buildParamsOverrideManager);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull DeploymentTaskContext deploymentTaskContext) {
        try (ArtifactoryManager client = TaskUtils.getArtifactoryManagerBuilderBuilder(this.downloadServerConfig, new BuildInfoLog(log, this.logger)).build();){
            this.initFileSpec((CommonTaskContext)deploymentTaskContext, this.genericContext, this.logger);
            SpecsHelper specsHelper = new SpecsHelper(new BuildInfoLog(log, this.logger));
            specsHelper.downloadArtifactsBySpec(this.fileSpec, client, deploymentTaskContext.getWorkingDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            this.buildInfoLog.error("Exception occurred while executing task", e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).failedWithError().build();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)deploymentTaskContext).success().build();
    }

    private ServerConfig getArtifactoryServerConfig(BuildParamsOverrideManager buildParamsOverrideManager) {
        ServerConfigManager serverConfigManager = ServerConfigManager.getInstance();
        ServerConfig selectedServerConfig = serverConfigManager.getServerConfigById(this.genericContext.getSelectedServerId());
        if (selectedServerConfig == null) {
            throw new IllegalArgumentException("Could not find Artifactory server. Please check the Artifactory server in the task configuration.");
        }
        Map runtimeContext = this.taskContext.getRuntimeTaskContext();
        return TaskUtils.getResolutionServerConfig(this.genericContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, false), this.genericContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, false), serverConfigManager, selectedServerConfig, buildParamsOverrideManager);
    }

    private void initFileSpec(CommonTaskContext context, GenericContext taskContext, BuildLogger logger) throws IOException {
        this.fileSpec = FileSpecUtils.getFileSpec(taskContext.isFileSpecInJobConfiguration(), taskContext.getJobConfigurationSpec(), taskContext.getFilePathSpec(), context.getWorkingDirectory(), this.customVariableContext, logger);
        logger.addBuildLogEntry("Spec: " + this.fileSpec);
        FileSpecUtils.validateFileSpec(this.fileSpec);
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.downloadServerConfig;
    }

    @Override
    protected String getTaskUsageName() {
        return "deployment_download";
    }
}

