/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.CollectBuildIssuesContext;
import org.jfrog.bamboo.task.ArtifactoryTaskType;
import org.jfrog.bamboo.util.FileSpecUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Issues;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.util.GitUtils;
import org.jfrog.build.extractor.issuesCollection.IssuesCollector;

public class ArtifactoryCollectBuildIssuesTask
extends ArtifactoryTaskType {
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private CollectBuildIssuesContext collectBuildIssuesContext;
    private CustomVariableContext customVariableContext;
    private BuildInfoHelper buildInfoHelper;

    public ArtifactoryCollectBuildIssuesTask(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        ContainerManager.autowireComponent((Object)this);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        this.collectBuildIssuesContext = new CollectBuildIssuesContext((Map<String, String>)this.taskContext.getConfigurationMap());
        BuildParamsOverrideManager buildParamsOverrideManager = new BuildParamsOverrideManager(this.customVariableContext);
        Map runtimeContext = context.getRuntimeTaskContext();
        BuildContext buildContext = ((TaskContext)context).getBuildContext();
        this.buildInfoHelper = BuildInfoHelper.createDeployBuildInfoHelper(this.collectBuildIssuesContext.getBuildName(buildContext), this.collectBuildIssuesContext.getBuildNumber(buildContext), this.taskContext, buildContext, this.environmentVariableAccessor, this.collectBuildIssuesContext.getArtifactoryServerId(), this.collectBuildIssuesContext.getOverriddenUsername(runtimeContext, this.buildInfoLog, true), this.collectBuildIssuesContext.getOverriddenPassword(runtimeContext, this.buildInfoLog, true), buildParamsOverrideManager);
    }

    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext taskContext) {
        try {
            File projectRootDir = this.getWorkingDirectory();
            if (projectRootDir == null) {
                this.buildInfoLog.error("No build directory found!");
                return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
            }
            Issues issues = this.collectBuildIssues(this.logger, projectRootDir);
            this.addIssuesToBuildInfoInContext(taskContext, issues);
        }
        catch (IOException | InterruptedException e) {
            this.buildInfoLog.error("Exception occurred while executing task", e);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.buildInfoHelper.getServerConfig();
    }

    @Override
    protected String getTaskUsageName() {
        return "collect_build_issues";
    }

    protected File getWorkingDirectory() {
        return TaskUtils.getVcsWorkingDirectory((TaskContext)this.taskContext);
    }

    private String getIssuesCollectionConfig(@NotNull CommonTaskContext context, BuildLogger buildLogger) throws IOException {
        if (this.isConfigSourceTaskConfiguration(context)) {
            buildLogger.addBuildLogEntry("Using task configuration config");
            return this.getTaskConfigurationConfig(context);
        }
        String configFileLocation = this.getConfigFilePath(context);
        buildLogger.addBuildLogEntry("Using config from file located at: " + configFileLocation);
        String config = FileSpecUtils.getSpecFromFile(this.getWorkingDirectory(), configFileLocation);
        return this.customVariableContext.substituteString(config);
    }

    private boolean isConfigSourceTaskConfiguration(@NotNull CommonTaskContext context) {
        return new CollectBuildIssuesContext((Map<String, String>)context.getConfigurationMap()).isConfigSourceTaskConfiguration();
    }

    private String getTaskConfigurationConfig(@NotNull CommonTaskContext context) {
        return new CollectBuildIssuesContext((Map<String, String>)context.getConfigurationMap()).getTaskConfigurationConfig();
    }

    private String getConfigFilePath(@NotNull CommonTaskContext context) {
        return new CollectBuildIssuesContext((Map<String, String>)context.getConfigurationMap()).getConfigFilePath();
    }

    private Issues collectBuildIssues(BuildLogger logger, File projectRootDir) throws IOException, InterruptedException {
        String config = this.getIssuesCollectionConfig(this.taskContext, logger);
        ArtifactoryManagerBuilder clientBuilder = this.buildInfoHelper.getClientBuilder(logger, log);
        String buildName = this.collectBuildIssuesContext.getBuildName(((TaskContext)this.taskContext).getBuildContext());
        Vcs vcs = GitUtils.extractVcs(projectRootDir, this.buildInfoLog);
        return new IssuesCollector().collectIssues(projectRootDir, this.buildInfoLog, config, clientBuilder, buildName, vcs, "");
    }

    private void addIssuesToBuildInfoInContext(@NotNull TaskContext taskContext, Issues issues) {
        BuildInfo build = this.buildInfoHelper.getBuilder(taskContext).build();
        build.setIssues(issues);
        this.taskBuildInfo = build;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

