/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.release.provider;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.release.provider.AbstractReleaseProvider;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.build.extractor.maven.reader.ModuleName;
import org.jfrog.build.extractor.maven.reader.ProjectReader;
import org.jfrog.build.extractor.maven.transformer.PomTransformer;

public class MavenReleaseProvider
extends AbstractReleaseProvider {
    protected MavenReleaseProvider(PackageManagersContext buildContext, BuildContext buildDefinition, BuildLogger buildLogger, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        super(buildContext, buildDefinition, buildLogger, customVariableContext, credentialsAccessor);
    }

    @Override
    protected Map<? extends String, ? extends String> getTaskConfiguration(BuildDefinition definition) {
        return TaskDefinitionHelper.findMavenDefinition(definition.getTaskDefinitions()).getConfiguration();
    }

    @Override
    public boolean transformDescriptor(Map<String, String> conf, boolean release) throws IOException, InterruptedException, RepositoryException {
        String moduleVersionConf = conf.get("moduleVersionConfiguration");
        if (StringUtils.isBlank((String)moduleVersionConf)) {
            return false;
        }
        if ("useExistingVersion".equals(moduleVersionConf)) {
            return false;
        }
        File rootDir = this.getSourceDir();
        if (rootDir == null) {
            return false;
        }
        Map<String, String> map = this.buildMapAccordingToStatus(conf, release);
        Map<ModuleName, String> buildVersionByModule = this.buildVersionByModule(map);
        File pom = this.getRootPom(rootDir);
        ProjectReader reader = new ProjectReader(pom);
        boolean changed = false;
        Map<ModuleName, File> modules = reader.read();
        for (Map.Entry<ModuleName, File> entry : modules.entrySet()) {
            String transformMessage = release ? "release" : "next development";
            this.log("Transforming: " + entry.getValue().getAbsolutePath() + " to " + transformMessage);
            this.coordinator.edit(entry.getValue());
            PomTransformer transformer = new PomTransformer(entry.getKey(), buildVersionByModule, this.getScmUrl(release), release);
            changed |= transformer.transform(entry.getValue()).booleanValue();
        }
        return changed;
    }

    private String getScmUrl(boolean release) {
        if (this.coordinator.isSubversion()) {
            if (release) {
                if (this.buildContext.releaseManagementContext.isCreateVcsTag()) {
                    return this.buildContext.releaseManagementContext.getTagUrl();
                }
            } else if (this.buildContext.releaseManagementContext.isCreateVcsTag()) {
                return this.coordinator.getRemoteUrlForPom();
            }
        }
        return null;
    }

    private Map<ModuleName, String> buildVersionByModule(Map<String, String> moduleNames) {
        HashMap<ModuleName, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : moduleNames.entrySet()) {
            String[] groupIdArtifactId = StringUtils.split((String)entry.getKey(), (String)":");
            result.put(new ModuleName(groupIdArtifactId[0], groupIdArtifactId[1]), entry.getValue());
        }
        return result;
    }

    private File getRootPom(File rootDir) {
        String subDirectory = ((Maven3BuildContext)this.buildContext).getWorkingSubDirectory();
        File rootPomFile = StringUtils.isNotBlank((String)subDirectory) ? new File(rootDir, subDirectory + "/pom.xml") : new File(rootDir, "pom.xml");
        return rootPomFile;
    }
}

