/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.processor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.util.TaskDefinitionHelper;
import org.jfrog.bamboo.util.Utils;
import org.jfrog.bamboo.util.version.VcsHelper;

public class BuildInfoCopier
extends AbstractBuildTask
implements CustomBuildProcessor {
    private static final Logger log = LogManager.getLogger(BuildInfoCopier.class);
    private volatile ArtifactManager artifactManager;
    private BuildLoggerManager buildLoggerManager;

    @NotNull
    public BuildContext call() throws Exception {
        File buildInfo;
        PlanResultKey planResultKey = this.buildContext.getPlanResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
        File checkoutDir = VcsHelper.getCheckoutDirectory(this.buildContext);
        if (checkoutDir == null) {
            return this.buildContext;
        }
        List taskDefinitions = this.buildContext.getBuildDefinition().getTaskDefinitions();
        TaskDefinition mavenDefinition = TaskDefinitionHelper.findMavenDefinition(taskDefinitions);
        if (mavenDefinition == null) {
            log.debug("No Maven task definition found");
            return this.buildContext;
        }
        Maven3BuildContext conf = new Maven3BuildContext(mavenDefinition.getConfiguration());
        String location = "target";
        String directory = conf.getWorkingSubDirectory();
        if (StringUtils.isNotBlank((String)directory)) {
            location = directory + "/" + location;
        }
        if ((buildInfo = new File(new File(checkoutDir, location), "build-info.json")).exists()) {
            log.info(buildLogger.addBuildLogEntry("Copying the buildinfo artifacts for build: " + this.buildContext.getPlanResultKey().getKey()));
            TaskDefinition definition = TaskDefinitionHelper.findMavenDefinition(this.buildContext.getRuntimeTaskDefinitions());
            String securityToken = Utils.getTaskSecurityToken(this.buildContext, definition);
            if (securityToken == null) {
                log.error("Security token not found");
                return this.buildContext;
            }
            ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("buildInfo", false, SecureToken.createFromString((String)securityToken));
            File buildInfoZip = this.createBuildInfoZip(buildInfo);
            if (buildInfoZip != null) {
                artifact.setLocation(location);
                artifact.setCopyPattern(buildInfoZip.getName());
                HashMap config = Maps.newHashMap();
                this.artifactManager.publish(buildLogger, planResultKey, checkoutDir, (ArtifactDefinitionContext)artifact, config, 1);
            }
        }
        return this.buildContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private File createBuildInfoZip(File buildInfoFile) throws IOException {
        File buildInfoZipFile = new File(buildInfoFile.getParent(), "build-info.json.zip");
        if (!buildInfoZipFile.exists() && !buildInfoZipFile.createNewFile()) {
            log.error("Unable to create build info archive: the file '" + buildInfoZipFile.getAbsolutePath() + "' could not be created.");
            return null;
        }
        FileInputStream buildInfoFileStream = null;
        DeflaterOutputStream stream = null;
        try {
            buildInfoFileStream = new FileInputStream(buildInfoFile);
            stream = new GZIPOutputStream(new FileOutputStream(buildInfoZipFile));
            ByteStreams.copy(buildInfoFileStream, stream);
        }
        finally {
            if (buildInfoFileStream != null) {
                try {
                    buildInfoFileStream.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buildInfoZipFile;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

