/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.exporter;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.task.AnyTask;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArtifactoryTaskExporter
implements TaskDefinitionExporter {
    private static final Logger log = LogManager.getLogger(ArtifactoryTaskExporter.class);

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        return Maps.newHashMap();
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        log.debug(String.format("Exporting task definition by id: %s and plugin key: %s", taskDefinition.getId(), taskDefinition.getPluginKey()));
        HashMap configurationMap = Maps.newHashMap();
        for (Map.Entry entry : taskDefinition.getConfiguration().entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            if (key.contains("password") || key.contains("passphrase") || key.contains("key")) {
                configurationMap.put(entry.getKey(), "/* SENSITIVE INFORMATION */");
                continue;
            }
            configurationMap.put(entry.getKey(), (String)entry.getValue());
        }
        return new AnyTask(new AtlassianModule(taskDefinition.getPluginKey())).configuration(configurationMap);
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

