/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.context.ArtifactoryBuildContext;

public class GenericContext
extends ArtifactoryBuildContext {
    public static final String PREFIX = "builder.artifactoryGenericBuilder.";
    public static final String SERVER_ID_PARAM = "artifactoryServerId";
    public static final String REPO_KEY = "builder.artifactoryGenericBuilder.deployableRepo";
    public static final String REPO_RESOLVE_KEY = "artifactory.generic.resolveRepo";
    public static final String USERNAME = "artifactory.generic.username";
    public static final String PASSWORD = "artifactory.generic.password";
    public static final String DEPLOY_PATTERN = "artifactory.generic.deployPattern";
    public static final String USE_SPECS_CHOICE = "artifactory.generic.useSpecsChoice";
    public static final String SPEC_SOURCE_CHOICE = "artifactory.generic.specSourceChoice";
    public static final String SPEC_SOURCE_JOB_CONFIGURATION = "artifactory.generic.jobConfiguration";
    public static final String SPEC_SOURCE_FILE = "artifactory.generic.file";
    public static final String RESOLVE_PATTERN = "artifactory.generic.resolvePattern";
    public static final String PUBLISH_BUILD_INFO = "artifactory.generic.publishBuildInfo";
    public static final String INCLUDE_ENV_VARS = "artifactory.generic.includeEnvVars";
    public static final String ARTIFACT_SPECS = "artifactory.generic.artifactSpecs";
    public static final String ENV_VARS_INCLUDE_PATTERNS = "artifactory.generic.envVarsIncludePatterns";
    public static final String ENV_VARS_EXCLUDE_PATTERNS = "artifactory.generic.envVarsExcludePatterns";
    public static final String SIGN_METHOD_MAP_KEY = "signMethods";
    public static final Map<String, String> SIGN_METHOD_MAP = ImmutableMap.of("false", "Don't Sign", "true", "Sign");

    public GenericContext(Map<String, String> env) {
        super("artifactory.generic.", env);
    }

    public static Set<String> getFieldsToCopy() {
        return Sets.newHashSet("builder.artifactoryGenericBuilder.artifactoryServerId", REPO_KEY, REPO_RESOLVE_KEY, USERNAME, PASSWORD, DEPLOY_PATTERN, SPEC_SOURCE_JOB_CONFIGURATION, "buildInfoAggregation", "captureBuildInfo", SPEC_SOURCE_FILE, ARTIFACT_SPECS, RESOLVE_PATTERN, PUBLISH_BUILD_INFO, INCLUDE_ENV_VARS, ENV_VARS_INCLUDE_PATTERNS, ENV_VARS_EXCLUDE_PATTERNS, USE_SPECS_CHOICE, SPEC_SOURCE_CHOICE, "artifactory.task.buildName", "artifactory.task.buildNumber", "resolver.overrideCredentialsChoice", "resolver.sharedCredentials", "deployer.overrideCredentialsChoice", "deployer.sharedCredentials");
    }

    public long getSelectedServerId() {
        String serverId = (String)this.env.get("builder.artifactoryGenericBuilder.artifactoryServerId");
        if (StringUtils.isBlank((String)serverId)) {
            serverId = (String)this.env.get("artifactory.generic.artifactoryServerId");
        }
        if (StringUtils.isBlank((String)serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getRepoKey() {
        String key = (String)this.env.get(REPO_KEY);
        if (StringUtils.isBlank((String)key)) {
            return (String)this.env.get("artifactory.generic.deployableRepo");
        }
        return key;
    }

    public String getDeployPattern() {
        return (String)this.env.get(DEPLOY_PATTERN);
    }

    public boolean isUseFileSpecs() {
        return "specs".equals(this.env.get(USE_SPECS_CHOICE));
    }

    public boolean isFileSpecInJobConfiguration() {
        return "jobConfiguration".equals(this.env.get(SPEC_SOURCE_CHOICE));
    }

    public String getJobConfigurationSpec() {
        return (String)this.env.get(SPEC_SOURCE_JOB_CONFIGURATION);
    }

    public String getFilePathSpec() {
        return (String)this.env.get(SPEC_SOURCE_FILE);
    }

    public String getResolvePattern() {
        return (String)this.env.get(RESOLVE_PATTERN);
    }

    public boolean isPublishBuildInfo() {
        return Boolean.parseBoolean((String)this.env.get(PUBLISH_BUILD_INFO));
    }

    public boolean isIncludeEnvVars() {
        return Boolean.parseBoolean((String)this.env.get(INCLUDE_ENV_VARS));
    }

    public String getEnvVarsIncludePatterns() {
        return (String)this.env.get(ENV_VARS_INCLUDE_PATTERNS);
    }

    public boolean isCaptureBuildInfo() {
        return Boolean.parseBoolean((String)this.env.get("captureBuildInfo"));
    }

    public String getEnvVarsExcludePatterns() {
        return (String)this.env.get(ENV_VARS_EXCLUDE_PATTERNS);
    }

    public String getArtifactSpecs() {
        return (String)this.env.get(ARTIFACT_SPECS);
    }

    public String getBuildName() {
        return (String)this.env.get("artifactory.task.buildName");
    }

    public String getBuildNumber() {
        return (String)this.env.get("artifactory.task.buildNumber");
    }
}

