/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.atlassian.bamboo.v2.build.BuildContext;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;

public abstract class ArtifactoryBuildContext {
    public static final String RESOLVER_OVERRIDE_CREDENTIALS_CHOICE = "resolver.overrideCredentialsChoice";
    public static final String DEPLOYER_OVERRIDE_CREDENTIALS_CHOICE = "deployer.overrideCredentialsChoice";
    public static final String RESOLVER_SHARED_CREDENTIALS = "resolver.sharedCredentials";
    public static final String DEPLOYER_SHARED_CREDENTIALS = "deployer.sharedCredentials";
    public static final String SERVER_ID_PARAM = "artifactoryServerId";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String BUILD_NAME = "artifactory.task.buildName";
    public static final String BUILD_NUMBER = "artifactory.task.buildNumber";
    public static final String DEFAULT_BUILD_NAME = "${bamboo.buildPlanName}";
    public static final String DEFAULT_BUILD_NUMBER = "${bamboo.buildNumber}";
    protected final Map<String, String> env;
    protected String prefix;

    public ArtifactoryBuildContext(Map<String, String> env) {
        this.env = env;
    }

    public ArtifactoryBuildContext(String credentialsPrefix, Map<String, String> env) {
        this(env);
        this.prefix = credentialsPrefix;
    }

    public long getArtifactoryServerId() {
        String serverId = this.env.get(this.prefix + SERVER_ID_PARAM);
        if (StringUtils.isBlank((String)serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getResolverOverrideCredentialsChoice() {
        return this.env.get(RESOLVER_OVERRIDE_CREDENTIALS_CHOICE);
    }

    public String getDeployerOverrideCredentialsChoice() {
        return this.env.get(DEPLOYER_OVERRIDE_CREDENTIALS_CHOICE);
    }

    public String getResolverSharedCredentials() {
        return this.env.get(RESOLVER_SHARED_CREDENTIALS);
    }

    public String getDeployerSharedCredentials() {
        return this.env.get(DEPLOYER_SHARED_CREDENTIALS);
    }

    public String getUsername() {
        return this.env.get(this.prefix + USERNAME_PARAM);
    }

    public String getPassword() {
        return this.env.get(this.prefix + PASSWORD_PARAM);
    }

    public String getResolverUsername() {
        return this.getUsername();
    }

    public String getDeployerUsername() {
        return this.getUsername();
    }

    public String getResolverPassword() {
        return this.getPassword();
    }

    public String getDeployerPassword() {
        return this.getPassword();
    }

    public String getBuildName(BuildContext buildContext) {
        String buildName = this.env.get(BUILD_NAME);
        if (org.apache.commons.lang3.StringUtils.isNotBlank(buildName)) {
            return buildName;
        }
        return buildContext.getPlanName();
    }

    public String getBuildNumber(BuildContext buildContext) {
        String buildNumber = this.env.get(BUILD_NUMBER);
        if (org.apache.commons.lang3.StringUtils.isNotBlank(buildNumber)) {
            return buildNumber;
        }
        return String.valueOf(buildContext.getBuildNumber());
    }

    public String getOverriddenUsername(Map<String, String> runtimeTaskContext, Log log, boolean deployer) {
        String username;
        switch (org.apache.commons.lang3.StringUtils.defaultString(deployer ? this.getDeployerOverrideCredentialsChoice() : this.getResolverOverrideCredentialsChoice())) {
            case "noOverriding": {
                return "";
            }
            case "sharedCredentials": {
                String username2 = runtimeTaskContext.get(deployer ? "deployerSharedCredentialsUser" : "resolverSharedCredentialsUser");
                String credentialsId = deployer ? this.getDeployerSharedCredentials() : this.getResolverSharedCredentials();
                log.info("Using Artifactory username '" + username2 + "' configured in credentials ID '" + credentialsId + "'");
                return username2;
            }
            case "usernamePassword": {
                String username3 = deployer ? this.getDeployerUsername() : this.getResolverUsername();
                log.info("Using Artifactory username '" + username3 + "' configured in job");
                return username3;
            }
        }
        String string = username = deployer ? this.getDeployerUsername() : this.getResolverUsername();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(username)) {
            log.info("Using Artifactory username '" + username + "' configured in job");
            return username;
        }
        return "";
    }

    public String getOverriddenPassword(Map<String, String> runtimeTaskContext, Log log, boolean deployer) {
        String password;
        switch (org.apache.commons.lang3.StringUtils.defaultString(deployer ? this.getDeployerOverrideCredentialsChoice() : this.getResolverOverrideCredentialsChoice())) {
            case "noOverriding": {
                return "";
            }
            case "sharedCredentials": {
                String credentialsId = deployer ? this.getDeployerSharedCredentials() : this.getResolverSharedCredentials();
                log.info("Using Artifactory password configured in credentials ID '" + credentialsId + "'");
                return runtimeTaskContext.get(deployer ? "deployerSharedCredentialsPassword" : "resolverSharedCredentialsPassword");
            }
            case "usernamePassword": {
                log.info("Using Artifactory password configured in job");
                return deployer ? this.getDeployerPassword() : this.getResolverPassword();
            }
        }
        String string = password = deployer ? this.getDeployerPassword() : this.getResolverPassword();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(password)) {
            log.info("Using Artifactory password configured in job");
            return password;
        }
        return "";
    }
}

