/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.DotNetBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;

public abstract class AbstractDotNetBuildConfiguration
extends AbstractArtifactoryConfiguration {
    private static final Set<String> FIELDS_TO_COPY = DotNetBuildContext.getFieldsToCopy();
    public static final String CFG_COMMAND_RESTORE = "restore";
    private static final String CFG_COMMAND_PUSH = "push";
    private static final Map<String, String> CFG_COMMAND_OPTIONS = ImmutableMap.of("restore", "restore", "push", "push");

    public AbstractDotNetBuildConfiguration(String capability) {
        super("artifactory.task.dotnet.", capability);
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateCommandsContext(context);
        context.put("adminConfig", this.administrationConfiguration);
        context.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        Plan plan = (Plan)context.get("plan");
        context.put("build", plan);
        context.put("dummyList", Lists.newArrayList());
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedResolutionServerId", -1);
        context.put("selectedResolutionRepoKey", "");
        context.put("selectedPublishingServerId", -1);
        context.put("selectedPublishingRepoKey", "");
        context.put("artifactory.task.dotnet.pushPattern", "*.nupkg");
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        String pushPattern;
        super.populateContextForEdit(context, taskDefinition);
        this.populateCommandsContext(context);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedResolutionServerId", context.get("artifactory.task.dotnet.resolutionArtifactoryServerId"));
        context.put("selectedPublishingServerId", context.get("artifactory.task.dotnet.artifactoryServerId"));
        String selectedResolutionRepoKey = context.get("artifactory.task.dotnet.resolutionRepo") != null ? context.get("artifactory.task.dotnet.resolutionRepo").toString() : "noResolutionRepoKeyConfigured";
        context.put("selectedResolutionRepoKey", selectedResolutionRepoKey);
        String selectedPublishingRepoKey = context.get("artifactory.task.dotnet.publishingRepo") != null ? context.get("artifactory.task.dotnet.publishingRepo").toString() : "noPublishingRepoKeyConfigured";
        context.put("selectedPublishingRepoKey", selectedPublishingRepoKey);
        context.put("serverConfigManager", this.serverConfigManager);
        String envVarsExcludePatterns = (String)context.get("envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        }
        if ((pushPattern = (String)context.get("artifactory.task.dotnet.pushPattern")) == null) {
            context.put("artifactory.task.dotnet.pushPattern", "*.nupkg");
        }
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(taskConfigMap, params, FIELDS_TO_COPY);
        DotNetBuildContext buildContext = new DotNetBuildContext(taskConfigMap);
        this.resetResolverConfigIfNeeded(buildContext);
        taskConfigMap.putAll(super.getSshFileContent(params, previousTaskDefinition));
        this.decryptFields(taskConfigMap);
        return taskConfigMap;
    }

    private void populateCommandsContext(Map<String, Object> context) {
        context.put("commandOptions", CFG_COMMAND_OPTIONS);
        context.put("artifactory.task.dotnet.command.choice", CFG_COMMAND_RESTORE);
    }

    @Override
    protected void resetResolverConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getResolutionArtifactoryServerId();
        if (serverId == -1L) {
            buildContext.resetResolverContextToDefault();
        }
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String executableKey;
        String repoKey;
        String serverKey;
        String commandChoiceKey = "artifactory.task.dotnet.command.choice";
        if (CFG_COMMAND_RESTORE.equals(params.getString(commandChoiceKey))) {
            serverKey = "artifactory.task.dotnet.resolutionArtifactoryServerId";
            repoKey = "artifactory.task.dotnet.resolutionRepo";
            TaskConfigurationValidations.validateArtifactoryServerAndRepo(serverKey, repoKey, this.serverConfigManager, params, errorCollection);
        }
        if (CFG_COMMAND_PUSH.equals(params.getString(commandChoiceKey))) {
            serverKey = "artifactory.task.dotnet.artifactoryServerId";
            repoKey = "artifactory.task.dotnet.publishingRepo";
            TaskConfigurationValidations.validateArtifactoryServerAndRepo(serverKey, repoKey, this.serverConfigManager, params, errorCollection);
        }
        if (StringUtils.isBlank((String)params.getString(executableKey = "artifactory.task.dotnet.executable"))) {
            errorCollection.addError(executableKey, "Please specify an Executable.");
        }
        TaskConfigurationValidations.validateCaptureBuildInfoParams("artifactory.task.buildName", "artifactory.task.buildNumber", "captureBuildInfo", params, errorCollection);
    }
}

