/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.admin.ServerConfigManager;
import org.jfrog.bamboo.configuration.util.TaskConfiguratorHelperImpl;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.release.vcs.VcsTypes;
import org.jfrog.bamboo.release.vcs.git.GitAuthenticationType;
import org.jfrog.bamboo.security.EncryptionHelper;

public abstract class AbstractArtifactoryConfiguration
extends AbstractTaskConfigurator
implements TaskTestResultsSupport,
BuildTaskRequirementSupport {
    protected I18nResolver i18nResolver;
    public static final String CFG_TEST_RESULTS_FILE_PATTERN_OPTION_CUSTOM = "customTestDirectory";
    public static final String CFG_TEST_RESULTS_FILE_PATTERN_OPTION_STANDARD = "standardTestDirectory";
    private static final Map<String, String> TEST_RESULTS_FILE_PATTERN_TYPES = ImmutableMap.of("standardTestDirectory", "Look in the standard test results directory.", "customTestDirectory", "Specify custom results directories");
    public static final String CFG_LEGACY_PATTERNS = "legacyPatterns";
    public static final String CFG_FILE_SPECS = "specs";
    public static final Map<String, String> USE_SPECS_OPTIONS = ImmutableMap.of("specs", "Specs", "legacyPatterns", "Legacy patterns (deprecated)");
    public static final String CVG_CRED_NO_OVERRIDE = "noOverriding";
    public static final String CVG_CRED_USERNAME_PASSWORD = "usernamePassword";
    public static final String CVG_CRED_SHARED_CREDENTIALS = "sharedCredentials";
    public static final Map<String, String> CFG_OVERRIDE_CREDENTIALS_OPTIONS = ImmutableMap.of("noOverriding", "No overriding", "usernamePassword", "Provide username and password", "sharedCredentials", "Use shared credentials");
    public static final String CFG_SPEC_SOURCE_FILE = "file";
    public static final String CFG_SPEC_SOURCE_JOB_CONFIGURATION = "jobConfiguration";
    public static final Map<String, String> CFG_SPEC_SOURCE = ImmutableMap.of("jobConfiguration", "Task configuration", "file", "File");
    public static final Map<String, String> SIGN_METHOD_MAP = ImmutableMap.of("false", "Don't Sign", "true", "Sign");
    public static final String SIGN_METHOD_MAP_KEY = "signMethods";
    protected transient ServerConfigManager serverConfigManager;
    protected transient CredentialsAccessor credentialsAccessor;
    protected AdministrationConfiguration administrationConfiguration;
    protected UIConfigSupport uiConfigSupport;
    private final String builderContextPrefix;
    private final String capabilityPrefix;
    private static final Logger log = LogManager.getLogger(AbstractArtifactoryConfiguration.class);
    protected TaskConfiguratorHelperImpl taskConfiguratorHelper = new TaskConfiguratorHelperImpl();

    protected AbstractArtifactoryConfiguration() {
        this(null, null);
    }

    protected AbstractArtifactoryConfiguration(String builderContextPrefix, @Nullable String capabilityPrefix) {
        this.serverConfigManager = ServerConfigManager.getInstance();
        if (this.administrationConfiguration == null) {
            this.administrationConfiguration = (AdministrationConfiguration)ContainerManager.getComponent((String)"administrationConfiguration");
        }
        this.builderContextPrefix = builderContextPrefix;
        this.capabilityPrefix = capabilityPrefix;
    }

    public String getTestDirectory(PackageManagersContext buildContext) {
        String directoryOption = buildContext.getTestDirectoryOption();
        if (CFG_TEST_RESULTS_FILE_PATTERN_OPTION_STANDARD.equals(directoryOption)) {
            return this.getDefaultTestDirectory();
        }
        if (CFG_TEST_RESULTS_FILE_PATTERN_OPTION_CUSTOM.equals(directoryOption)) {
            return buildContext.getTestDirectory();
        }
        return null;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.serverConfigManager = ServerConfigManager.getInstance();
        this.populateContextForAllOperations(context);
    }

    public void populateLegacyContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        if (!Boolean.parseBoolean((String)taskDefinition.getConfiguration().get("buildInfoAggregation"))) {
            context.put("captureBuildInfo", false);
            context.put("publishBuildInfo", true);
        }
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.serverConfigManager = ServerConfigManager.getInstance();
        this.populateContextForAllOperations(context);
    }

    public void populateLegacyContextForCreate(@NotNull Map<String, Object> context) {
        context.put("buildInfoAggregation", true);
        context.put("captureBuildInfo", true);
        context.put("publishBuildInfo", false);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map taskConfigMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        taskConfigMap.put("baseUrl", this.administrationConfiguration.getBaseUrl());
        return taskConfigMap;
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        HashSet<Requirement> requirements = Sets.newHashSet();
        if (StringUtils.isNotBlank(this.builderContextPrefix)) {
            this.taskConfiguratorHelper.addJdkRequirement(requirements, taskDefinition, this.builderContextPrefix + "buildJdk");
            if (!this.isUseWrapper(taskDefinition) && StringUtils.isNotBlank(this.capabilityPrefix)) {
                this.taskConfiguratorHelper.addSystemRequirementFromConfiguration(requirements, taskDefinition, this.builderContextPrefix + "executable", this.capabilityPrefix);
            }
        }
        return requirements;
    }

    protected boolean isUseWrapper(TaskDefinition taskDefinition) {
        return false;
    }

    protected void populateContextWithConfiguration(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition, Set<String> fieldsToCopy) {
        this.encryptFields(taskDefinition.getConfiguration());
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, fieldsToCopy);
        this.decryptFields(taskDefinition.getConfiguration());
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put("uiConfigBean", this.uiConfigSupport);
        context.put("testDirectoryTypes", TEST_RESULTS_FILE_PATTERN_TYPES);
        context.put("envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        context.put("artifactory.task.buildName", "${bamboo.buildPlanName}");
        context.put("artifactory.task.buildNumber", "${bamboo.buildNumber}");
        context.put(SIGN_METHOD_MAP_KEY, SIGN_METHOD_MAP);
        context.put("overrideCredentialsOptions", CFG_OVERRIDE_CREDENTIALS_OPTIONS);
        context.put("useSpecsOptions", USE_SPECS_OPTIONS);
        context.put("artifactory.generic.useSpecsChoice", CFG_FILE_SPECS);
        context.put("specSourceOptions", CFG_SPEC_SOURCE);
        context.put("artifactory.generic.specSourceChoice", CFG_SPEC_SOURCE_JOB_CONFIGURATION);
        context.put("credentialsAccessor", this.credentialsAccessor);
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    protected String readFileByKey(ActionParametersMap params, String keyToRead) {
        File private_key_file = (File)params.getFiles().get(keyToRead);
        if (private_key_file != null) {
            try {
                return FileUtils.readFileToString(private_key_file, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("Cannot read uploaded file", (Throwable)e);
            }
        } else {
            log.error("Unable to load file from config submission!");
        }
        return null;
    }

    private boolean isEncrypted(String value) {
        String decryptedValue = EncryptionHelper.decryptIfNeeded(value);
        return !decryptedValue.equals(value);
    }

    private void encOrDecFields(Map<String, String> taskConfigMap, boolean enc) {
        for (Map.Entry<String, String> entry : taskConfigMap.entrySet()) {
            String key = entry.getKey().toLowerCase();
            if (!this.shouldEncrypt(key)) continue;
            String value = entry.getValue();
            if (this.isEncrypted(value)) {
                value = EncryptionHelper.decryptIfNeeded(value);
            }
            if (enc) {
                value = EncryptionHelper.encryptForUi(value);
            }
            entry.setValue(value);
        }
    }

    private boolean shouldEncrypt(String key) {
        return key.contains("artifactory") && (key.contains("password") || key.contains("ssh"));
    }

    private void encryptFields(Map<String, String> taskConfigMap) {
        this.encOrDecFields(taskConfigMap, true);
    }

    protected void decryptFields(Map<String, String> taskConfigMap) {
        this.encOrDecFields(taskConfigMap, false);
    }

    protected void resetDeployerConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getArtifactoryServerId();
        if (serverId == -1L) {
            buildContext.resetDeployerContextToDefault();
        }
    }

    protected void resetResolverConfigIfNeeded(PackageManagersContext buildContext) {
        long serverId = buildContext.getArtifactoryServerId();
        if (serverId == -1L) {
            buildContext.resetResolverContextToDefault();
        }
    }

    protected abstract String getKey();

    protected String getDefaultTestDirectory() {
        throw new UnsupportedOperationException("This method is not implemented for class " + ((Object)((Object)this)).getClass());
    }

    protected List<NameValuePair> getGitAuthenticationTypes() {
        return Arrays.stream(GitAuthenticationType.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthTypeName((String)name))).collect(Collectors.toList());
    }

    protected List<NameValuePair> getVcsTypes() {
        return Arrays.stream(VcsTypes.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getVcsTypeName((String)name))).collect(Collectors.toList());
    }

    protected Map<String, String> getSshFileContent(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        HashMap<String, String> taskConfigMap = new HashMap<String, String>();
        String sshFileKey = "artifactory.vcs.git.ssh.key";
        String sshFileContent = this.readFileByKey(params, sshFileKey);
        if (StringUtils.isNotBlank(sshFileContent)) {
            taskConfigMap.put(sshFileKey, sshFileContent);
        } else if (previousTaskDefinition != null) {
            taskConfigMap.put(sshFileKey, (String)previousTaskDefinition.getConfiguration().get(sshFileKey));
        }
        return taskConfigMap;
    }

    private String getVcsTypeName(String vcsType) {
        return this.i18nResolver.getText("artifactory.vcs.type." + StringUtils.lowerCase(vcsType));
    }

    private String getAuthTypeName(String authType) {
        return this.i18nResolver.getText("artifactory.vcs.git.authenticationType." + StringUtils.lowerCase(authType));
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public static void populateDefaultEnvVarsExcludePatternsInBuildContext(@NotNull Map<String, Object> context) {
        String envVarsExcludePatterns = (String)context.get("envVarsExcludePatterns");
        if (envVarsExcludePatterns == null) {
            context.put("envVarsExcludePatterns", "*password*,*pwd*,*secret*,*security*,*key*,*token*");
        }
    }

    public static void populateDefaultBuildNameNumberInBuildContext(@NotNull Map<String, Object> context) {
        String buildNumber;
        String buildName = (String)context.get("artifactory.task.buildName");
        if (buildName == null) {
            context.put("artifactory.task.buildName", "${bamboo.buildPlanName}");
        }
        if ((buildNumber = (String)context.get("artifactory.task.buildNumber")) == null) {
            context.put("artifactory.task.buildNumber", "${bamboo.buildNumber}");
        }
    }
}

