/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.buildinfo.action;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfrog.bamboo.util.PublishedBuildDetails;
import org.jfrog.bamboo.util.PublishedBuilds;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;

public class BuildInfoAction
extends ViewBuildResults {
    transient Logger log = LogManager.getLogger(BuildInfoAction.class);
    private List<PublishedBuildDetails> publishedBuildsDetails = new ArrayList<PublishedBuildDetails>();

    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        BuildResultsSummary summary = this.getBuildResultsSummary();
        if (summary == null) {
            this.log.error("This build has no results summary");
            return "error";
        }
        String pbAsString = (String)summary.getCustomBuildData().get("org.jfrog.bamboo.buildInfo.published");
        if (StringUtils.isNotBlank((String)pbAsString)) {
            PublishedBuilds pb = BuildInfoExtractorUtils.jsonStringToGeneric(pbAsString, PublishedBuilds.class);
            this.publishedBuildsDetails = pb.getBuilds();
        }
        if (this.publishedBuildsDetails.isEmpty()) {
            this.publishedBuildsDetails.add(this.createDefaultPublishedBuildDetails((ResultsSummary)summary));
        }
        for (PublishedBuildDetails publishedBuildDetails : this.publishedBuildsDetails) {
            StringBuilder urlStringBuilder = new StringBuilder(publishedBuildDetails.getArtifactoryUrl());
            if (!urlStringBuilder.toString().endsWith("/")) {
                urlStringBuilder.append("/");
            }
            urlStringBuilder.append("webapp/builds/").append(publishedBuildDetails.getBuildName()).append("/").append(publishedBuildDetails.getBuildNumber());
            publishedBuildDetails.setBuildUrl(urlStringBuilder.toString());
        }
        return "input";
    }

    private PublishedBuildDetails createDefaultPublishedBuildDetails(ResultsSummary summary) {
        String artifactoryUrl = (String)summary.getCustomBuildData().get("org.jfrog.bamboo.buildInfo.serverUrl");
        String buildName = this.getImmutableBuild().getName();
        String buildNumber = String.valueOf(this.getBuildNumber());
        return new PublishedBuildDetails(artifactoryUrl, buildName, buildNumber);
    }

    public List<PublishedBuildDetails> getPublishedBuildsDetails() {
        return this.publishedBuildsDetails;
    }

    public void setPublishedBuildsDetails(List<PublishedBuildDetails> publishedBuildsDetails) {
        this.publishedBuildsDetails = publishedBuildsDetails;
    }
}

