/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.MavenAndIvyBuildInfoDataHelperBase;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.ProxyUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class MavenDataHelper
extends MavenAndIvyBuildInfoDataHelperBase {
    private String resolverUsername;
    private String resolverPassword;
    private String resolverUrl;

    public MavenDataHelper(BuildParamsOverrideManager buildParamsOverrideManager, TaskContext context, PackageManagersContext buildContext, EnvironmentVariableAccessor envVarAccessor, String artifactoryPluginVersion, boolean aggregateBuildInfo) {
        super(buildParamsOverrideManager, context, buildContext, envVarAccessor, artifactoryPluginVersion, aggregateBuildInfo);
        long selectedServerId = buildContext.getArtifactoryServerId();
        if (selectedServerId == -1L && (selectedServerId = buildContext.getResolutionArtifactoryServerId()) != -1L && this.isServerConfigured(selectedServerId)) {
            this.setClientData(context, buildContext, this.clientConf, this.selectedServerConfig, envVarAccessor.getEnvironment((CommonTaskContext)context));
        }
    }

    @Override
    protected void setClientData(TaskContext taskContext, PackageManagersContext builder, ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, Map<String, String> environment) {
        long serverId;
        ServerConfig resolutionServerConfig;
        Maven3BuildContext buildContext = (Maven3BuildContext)builder;
        clientConf.publisher.setRecordAllDependencies(buildContext.isRecordAllDependencies());
        String resolutionRepo = this.overrideParam(buildContext.getResolutionRepo(), "artifactory.override.resolve.repo");
        if (this.isResolutionConfigured(buildContext, resolutionRepo) && (resolutionServerConfig = this.serverConfigManager.getServerConfigById(serverId = buildContext.getResolutionArtifactoryServerId())) != null) {
            this.setResolverProperties(taskContext, buildContext, resolutionServerConfig);
            clientConf.resolver.setContextUrl(this.resolverUrl);
            clientConf.resolver.setRepoKey(resolutionRepo);
            clientConf.resolver.setUsername(this.resolverUsername);
            ProxyUtils.setProxyConfigurationToArtifactoryClientConfig(this.resolverUrl, clientConf);
        }
    }

    @Override
    public void addPasswordsSystemProps(List<String> command, PackageManagersContext builder, @NotNull TaskContext context) {
        Maven3BuildContext buildContext = (Maven3BuildContext)builder;
        super.addPasswordsSystemProps(command, buildContext, context);
        if (this.resolverPassword == null) {
            return;
        }
        this.clientConf.resolver.setPassword(this.resolverPassword);
        command.add("-D" + this.clientConf.resolver.getPrefix() + "password=" + this.clientConf.resolver.getPassword());
        context.getBuildContext().getVariableContext().addLocalVariable("artifactory.password.mask.b", this.clientConf.resolver.getPassword());
    }

    private boolean isResolutionConfigured(Maven3BuildContext buildContext, String resolutionRepo) {
        return buildContext.isResolveFromArtifactory() && StringUtils.isNotBlank((String)resolutionRepo) && !"noResolutionRepoKeyConfigured".equals(resolutionRepo) && this.serverConfigManager.getServerConfigById(buildContext.getResolutionArtifactoryServerId()) != null;
    }

    private void setResolverProperties(TaskContext taskContext, Maven3BuildContext buildContext, ServerConfig resolutionServerConfig) {
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        BuildInfoLog buildInfoLog = new BuildInfoLog(log, taskContext.getBuildLogger());
        ServerConfig overriderServerConfig = TaskUtils.getResolutionServerConfig(buildContext.getOverriddenUsername(runtimeContext, buildInfoLog, false), buildContext.getOverriddenPassword(runtimeContext, buildInfoLog, false), this.serverConfigManager, resolutionServerConfig, this.buildParamsOverrideManager);
        this.resolverUrl = resolutionServerConfig.getUrl();
        this.resolverUsername = overriderServerConfig.getUsername();
        this.resolverPassword = overriderServerConfig.getPassword();
    }

    public ServerConfig getResolveServer() {
        if (this.resolverUrl == null) {
            return null;
        }
        return new ServerConfig(this.selectedServerConfig.getId(), this.resolverUrl, this.resolverUsername, this.resolverPassword, this.selectedServerConfig.getTimeout());
    }
}

