/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BaseBuildInfoHelper;
import org.jfrog.bamboo.configuration.BuildParamsOverrideManager;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.BuildInfoLog;
import org.jfrog.bamboo.util.ProxyUtils;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.version.VcsHelper;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.joda.time.DateTime;

public abstract class MavenAndIvyBuildInfoDataHelperBase
extends BaseBuildInfoHelper {
    protected ArtifactoryClientConfiguration clientConf;
    protected ServerConfig selectedServerConfig;
    protected String deployerUsername;
    protected String deployerPassword;
    protected String deployerUrl;

    public MavenAndIvyBuildInfoDataHelperBase(BuildParamsOverrideManager buildParamsOverrideManager, TaskContext context, PackageManagersContext abstractBuildContext, EnvironmentVariableAccessor envVarAccessor, String artifactoryPluginVersion, boolean aggregateBuildInfo) {
        BuildContext buildContext = context.getBuildContext();
        super.init(buildParamsOverrideManager, context.getBuildContext(), context.getBuildLogger());
        long selectedServerId = abstractBuildContext.getArtifactoryServerId();
        this.clientConf = new ArtifactoryClientConfiguration(new NullLog());
        if (selectedServerId != -1L && this.isServerConfigured(selectedServerId)) {
            this.setDeployerProperties(context, abstractBuildContext);
            this.setBuilderData(context, abstractBuildContext, this.selectedServerConfig, this.clientConf, envVarAccessor.getEnvironment((CommonTaskContext)context), envVarAccessor.getEnvironment(), artifactoryPluginVersion);
            this.setDataToContext(buildContext, abstractBuildContext);
        } else if (aggregateBuildInfo) {
            this.setBuilderData(context, abstractBuildContext, this.selectedServerConfig, this.clientConf, envVarAccessor.getEnvironment((CommonTaskContext)context), envVarAccessor.getEnvironment(), artifactoryPluginVersion);
            this.setDataToContext(buildContext, abstractBuildContext);
        }
    }

    protected boolean isServerConfigured(long selectedServerId) {
        this.selectedServerConfig = this.getConfiguredServer(this.buildInfoLog, selectedServerId);
        return this.selectedServerConfig != null;
    }

    private void setDataToContext(BuildContext context, PackageManagersContext buildContext) {
        if (this.selectedServerConfig != null) {
            String serverUrl = this.serverConfigManager.substituteVariables(this.selectedServerConfig.getUrl());
            context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.serverUrl", serverUrl);
        }
        context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.buildInfo.activated", "true");
        context.getBuildResult().getCustomBuildData().put("org.jfrog.bamboo.release.activated", String.valueOf(buildContext.releaseManagementContext.isActivateReleaseManagement()));
    }

    public String createBuildInfoPropsFileAndGetItsPath(boolean shouldCaptureBuildInfo, File bambooTmp) throws IOException {
        if (this.selectedServerConfig == null && !shouldCaptureBuildInfo) {
            return null;
        }
        try {
            File tempPropertiesFile = File.createTempFile("buildInfo", ".properties", bambooTmp);
            this.clientConf.setPropertiesFile(tempPropertiesFile.getAbsolutePath());
            this.clientConf.persistToPropertiesFile();
            return tempPropertiesFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("Error occurred while writing build info properties to a temp file. Build info collection is disabled.", (Throwable)e);
            throw e;
        }
    }

    public String createBuildInfoJSonFileAndGetItsPath(File bambooTmp) throws IOException {
        try {
            File buildInfoJsonTempFile = File.createTempFile("generated.build.info", ".json", bambooTmp);
            this.clientConf.info.setGeneratedBuildInfoFilePath(buildInfoJsonTempFile.getAbsolutePath());
            return buildInfoJsonTempFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("Error occurred while creating temp build info JSON file.", (Throwable)e);
            throw e;
        }
    }

    public void addPasswordsSystemProps(List<String> command, PackageManagersContext buildContext, @NotNull TaskContext context) {
        if (this.deployerPassword == null) {
            return;
        }
        command.add("-D" + this.clientConf.publisher.getPrefix() + "password=" + this.deployerPassword);
        context.getBuildContext().getVariableContext().addLocalVariable("artifactory.password.mask.a", this.deployerPassword);
    }

    private void setBuilderData(TaskContext taskContext, PackageManagersContext buildContext, ServerConfig serverConfig, ArtifactoryClientConfiguration clientConf, Map<String, String> environment, Map<String, String> generalEnv, String pluginVersion) {
        Object[] vcsUrls;
        String buildName = buildContext.getBuildName(this.context);
        clientConf.info.setArtifactoryPluginVersion(pluginVersion);
        clientConf.info.setBuildName(buildName);
        clientConf.publisher.addMatrixParam("build.name", buildName);
        String buildNumber = buildContext.getBuildNumber(this.context);
        clientConf.info.setBuildNumber(buildNumber);
        clientConf.publisher.addMatrixParam("build.number", buildNumber);
        String vcsRevision = VcsHelper.getRevisionKey(this.context);
        if (StringUtils.isNotBlank((String)vcsRevision)) {
            clientConf.info.setVcsRevision(vcsRevision);
            clientConf.publisher.addMatrixParam("vcs.revision", vcsRevision);
        }
        if (!ArrayUtils.isEmpty((Object[])(vcsUrls = VcsHelper.getVcsUrls(this.context)))) {
            clientConf.info.setVcsUrl((String)vcsUrls[0]);
        }
        String buildTimeStampVal = (String)this.context.getBuildResult().getCustomBuildData().get("buildTimeStamp");
        long buildTimeStamp = System.currentTimeMillis();
        if (StringUtils.isNotBlank((String)buildTimeStampVal)) {
            buildTimeStamp = new DateTime((Object)buildTimeStampVal).getMillis();
        }
        String buildTimeStampString = String.valueOf(buildTimeStamp);
        clientConf.info.setBuildTimestamp(buildTimeStampString);
        clientConf.publisher.addMatrixParam("build.timestamp", buildTimeStampString);
        clientConf.setActivateRecorder(true);
        StringBuilder summaryUrlBuilder = new StringBuilder(this.bambooBaseUrl);
        if (!this.bambooBaseUrl.endsWith("/")) {
            summaryUrlBuilder.append("/");
        }
        String buildUrl = summaryUrlBuilder.append("browse/").append(EscapeChars.forFormSubmission((String)this.context.getPlanResultKey().getKey())).toString();
        clientConf.info.setBuildUrl(buildUrl);
        this.setBuildParentData(clientConf, this.context.getTriggerReason());
        String principal = this.getTriggeringUserNameRecursively(this.context);
        if (StringUtils.isBlank((String)principal)) {
            principal = "auto";
        }
        clientConf.info.setPrincipal(principal);
        clientConf.info.setAgentName("Bamboo");
        clientConf.info.setAgentVersion(BuildUtils.getVersionAndBuild());
        clientConf.info.setReleaseEnabled(buildContext.releaseManagementContext.isActivateReleaseManagement());
        clientConf.info.setReleaseComment(buildContext.releaseManagementContext.getStagingComment());
        this.setClientData(taskContext, buildContext, clientConf, serverConfig, environment);
        if (this.selectedServerConfig != null) {
            this.setPublisherData(buildContext, clientConf, serverConfig, environment);
        } else {
            this.setEmptyPublisherData(clientConf);
        }
        this.setIncludeEnvVars(buildContext, clientConf);
        Map<String, String> props = Maps.newHashMap(environment);
        props.putAll(generalEnv);
        props = TaskUtils.getEscapedEnvMap(props);
        props.putAll(this.getBuildInfoConfigPropertiesFileParams(props.get("buildInfoConfig.propertiesFile")));
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(buildContext.getEnvVarsIncludePatterns(), buildContext.getEnvVarsExcludePatterns());
        clientConf.info.addBuildVariables(props, patterns);
        clientConf.fillFromProperties(props, patterns);
    }

    private void setBuildParentData(ArtifactoryClientConfiguration clientConf, TriggerReason triggerReason) {
        String triggeringBuildResultKey;
        if (triggerReason instanceof DependencyTriggerReason && StringUtils.isNotBlank((String)(triggeringBuildResultKey = ((DependencyTriggerReason)triggerReason).getTriggeringBuildResultKey())) && StringUtils.split((String)triggeringBuildResultKey, (String)"-").length == 3) {
            String triggeringBuildKey = triggeringBuildResultKey.substring(0, triggeringBuildResultKey.lastIndexOf("-"));
            String triggeringBuildNumber = triggeringBuildResultKey.substring(triggeringBuildResultKey.lastIndexOf("-") + 1);
            String parentBuildName = this.getBuildName(triggeringBuildKey);
            if (StringUtils.isBlank((String)parentBuildName)) {
                log.error("Received a null build parent name.");
            }
            clientConf.info.setParentBuildName(parentBuildName);
            clientConf.publisher.addMatrixParam("build.parentName", parentBuildName);
            clientConf.info.setParentBuildNumber(triggeringBuildNumber);
            clientConf.publisher.addMatrixParam("build.parentNumber", triggeringBuildNumber);
        }
    }

    protected abstract void setClientData(TaskContext var1, PackageManagersContext var2, ArtifactoryClientConfiguration var3, ServerConfig var4, Map<String, String> var5);

    private void setPublisherData(PackageManagersContext buildContext, ArtifactoryClientConfiguration clientConf, ServerConfig serverConfig, Map<String, String> environment) {
        clientConf.publisher.setContextUrl(this.deployerUrl);
        clientConf.setTimeout(serverConfig.getTimeout());
        clientConf.publisher.setUsername(this.deployerUsername);
        clientConf.publisher.setRepoKey(this.getPublishingRepoKey(buildContext, environment));
        clientConf.publisher.setPublishArtifacts(buildContext.isPublishArtifacts());
        clientConf.publisher.setIncludePatterns(buildContext.getIncludePattern());
        clientConf.publisher.setExcludePatterns(buildContext.getExcludePattern());
        clientConf.publisher.setFilterExcludedArtifactsFromBuild(buildContext.isFilterExcludedArtifactsFromBuild());
        if (buildContext.isCaptureBuildInfo()) {
            clientConf.publisher.setPublishBuildInfo(false);
        } else {
            clientConf.publisher.setPublishBuildInfo(buildContext.isPublishBuildInfo());
        }
        ProxyUtils.setProxyConfigurationToArtifactoryClientConfig(this.deployerUrl, clientConf);
    }

    private void setEmptyPublisherData(ArtifactoryClientConfiguration clientConf) {
        clientConf.publisher.setContextUrl("http://empty_url");
        clientConf.publisher.setRepoKey("empty_repo");
        clientConf.publisher.setPublishArtifacts(false);
        clientConf.publisher.setPublishBuildInfo(false);
    }

    private void setIncludeEnvVars(PackageManagersContext buildContext, ArtifactoryClientConfiguration clientConf) {
        clientConf.setIncludeEnvVars(buildContext.isIncludeEnvVars());
        clientConf.setEnvVarsIncludePatterns(buildContext.getEnvVarsIncludePatterns());
        clientConf.setEnvVarsExcludePatterns(buildContext.getEnvVarsExcludePatterns());
    }

    private void setDeployerProperties(TaskContext taskContext, PackageManagersContext buildContext) {
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        BuildInfoLog buildInfoLog = new BuildInfoLog(log, taskContext.getBuildLogger());
        ServerConfig overriderServerConfig = TaskUtils.getResolutionServerConfig(buildContext.getOverriddenUsername(runtimeContext, buildInfoLog, true), buildContext.getOverriddenPassword(runtimeContext, buildInfoLog, true), this.serverConfigManager, this.selectedServerConfig, this.buildParamsOverrideManager);
        this.deployerUrl = overriderServerConfig.getUrl();
        this.deployerUsername = overriderServerConfig.getUsername();
        this.deployerPassword = overriderServerConfig.getPassword();
    }

    public ServerConfig getDeployServer() {
        if (this.deployerUrl == null) {
            return null;
        }
        return new ServerConfig(this.selectedServerConfig.getId(), this.deployerUrl, this.deployerUsername, this.deployerPassword, this.selectedServerConfig.getTimeout());
    }
}

