/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.plexus.ClassRealmUtil;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.composition.DefaultCompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private final Map<ClassRealm, SortedMap<String, Map<String, Set<ComponentDescriptor<?>>>>> index = new LinkedHashMap();
    private final CompositionResolver compositionResolver = new DefaultCompositionResolver();

    private Map<String, Set<ComponentDescriptor<?>>> getComponentDescriptors(String role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        Set<ClassRealm> realms = ClassRealmUtil.getContextRealms(null);
        if (realms.isEmpty()) {
            realms.addAll(this.index.keySet());
        }
        LinkedHashMap roleHintIndex = new LinkedHashMap();
        for (ClassRealm realm : realms) {
            Map descriptors;
            SortedMap<String, Map<String, Set<ComponentDescriptor<?>>>> roleIndex = this.index.get(realm);
            if (roleIndex == null || (descriptors = (Map)roleIndex.get(role)) == null) continue;
            for (Map.Entry descriptor : descriptors.entrySet()) {
                LinkedHashSet componentDescriptors = (LinkedHashSet)roleHintIndex.get(descriptor.getKey());
                if (componentDescriptors == null) {
                    componentDescriptors = new LinkedHashSet();
                    roleHintIndex.put(descriptor.getKey(), componentDescriptors);
                }
                componentDescriptors.addAll((Collection)descriptor.getValue());
            }
        }
        return Collections.unmodifiableMap(roleHintIndex);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String roleHint) {
        Collection descriptors;
        Map<String, Set<ComponentDescriptor<?>>> roleHintIndex = this.getComponentDescriptors(role);
        if (StringUtils.isNotEmpty(roleHint)) {
            descriptors = (ArrayList)((Object)roleHintIndex.get(roleHint));
        } else {
            ArrayList allDescriptors = new ArrayList();
            descriptors = roleHintIndex.get("default");
            if (descriptors != null) {
                allDescriptors.addAll(descriptors);
            }
            for (String hint : roleHintIndex.keySet()) {
                descriptors = roleHintIndex.get(hint);
                if (descriptors == null) continue;
                allDescriptors.addAll(descriptors);
            }
            descriptors = allDescriptors;
        }
        if (descriptors != null) {
            for (ComponentDescriptor descriptor : descriptors) {
                Class implClass = descriptor.getImplementationClass();
                if (!CastUtils.isAssignableFrom(type, implClass) && (Object.class != implClass || !role.equals(type.getName()))) continue;
                return descriptor;
            }
        }
        return null;
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        TreeMap<String, ComponentDescriptor<T>> descriptors = new TreeMap<String, ComponentDescriptor<T>>();
        for (Set<ComponentDescriptor<?>> componentDescriptors : this.getComponentDescriptors(role).values()) {
            for (ComponentDescriptor<?> descriptor : componentDescriptors) {
                if (descriptors.containsKey(descriptor.getRoleHint()) || !CastUtils.isAssignableFrom(type, descriptor.getImplementationClass())) continue;
                descriptors.put(descriptor.getRoleHint(), descriptor);
            }
        }
        return descriptors;
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        ArrayList<ComponentDescriptor<T>> descriptors = new ArrayList<ComponentDescriptor<T>>();
        for (Set<ComponentDescriptor<?>> componentDescriptors : this.getComponentDescriptors(role).values()) {
            for (ComponentDescriptor<?> descriptor : componentDescriptors) {
                if (!CastUtils.isAssignableFrom(type, descriptor.getImplementationClass())) continue;
                descriptors.add(descriptor);
            }
        }
        return descriptors;
    }

    @Override
    @Deprecated
    public ComponentDescriptor<?> getComponentDescriptor(String role, String roleHint, ClassRealm realm) {
        HashSet<ClassRealm> realms = new HashSet<ClassRealm>();
        for (ClassRealm r = realm; r != null; r = r.getParentRealm()) {
            realms.add(r);
        }
        for (ComponentDescriptor<?> componentDescriptor : this.getComponentDescriptors(role).get(roleHint)) {
            if (!realms.contains(componentDescriptor.getRealm())) continue;
            return componentDescriptor;
        }
        return null;
    }

    @Override
    public void removeComponentRealm(ClassRealm classRealm) {
        this.index.remove(classRealm);
    }

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CycleDetectedInComponentGraphException {
        String roleHint;
        LinkedHashSet componentDescriptors;
        String role;
        LinkedHashMap roleHintIndex;
        ClassRealm classRealm = componentDescriptor.getRealm();
        SortedMap<String, Map<String, Set<ComponentDescriptor<?>>>> roleIndex = this.index.get(classRealm);
        if (roleIndex == null) {
            roleIndex = new TreeMap();
            this.index.put(classRealm, roleIndex);
        }
        if ((roleHintIndex = (LinkedHashMap)roleIndex.get(role = componentDescriptor.getRole())) == null) {
            roleHintIndex = new LinkedHashMap();
            roleIndex.put(role, roleHintIndex);
        }
        if ((componentDescriptors = (LinkedHashSet)roleHintIndex.get(roleHint = componentDescriptor.getRoleHint())) == null) {
            componentDescriptors = new LinkedHashSet();
            roleHintIndex.put(roleHint, componentDescriptors);
        }
        componentDescriptors.add(componentDescriptor);
        this.compositionResolver.addComponentDescriptor(componentDescriptor);
    }
}

