/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public abstract class AbstractDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Component
    private RuntimeInformation runtimeInformation;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected RepositorySystem repositorySystem;
    private static final String AFFECTED_MAVEN_PACKAGING = "maven-plugin";
    private static final String FIXED_MAVEN_VERSION = "3.9.0";

    void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    protected void warnIfAffectedPackagingAndMaven(String packaging) {
        if (AFFECTED_MAVEN_PACKAGING.equals(packaging)) {
            try {
                GenericVersionScheme versionScheme = new GenericVersionScheme();
                Version fixedMavenVersion = versionScheme.parseVersion(FIXED_MAVEN_VERSION);
                Version currentMavenVersion = versionScheme.parseVersion(this.runtimeInformation.getMavenVersion());
                if (fixedMavenVersion.compareTo(currentMavenVersion) > 0) {
                    this.getLog().warn("");
                    this.getLog().warn("You are about to deploy a maven-plugin using Maven " + currentMavenVersion + ".");
                    this.getLog().warn("This plugin should be used ONLY with Maven 3.9.0 and newer, as MNG-7055");
                    this.getLog().warn("is fixed in those versions of Maven only!");
                    this.getLog().warn("");
                }
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
    }

    protected RemoteRepository getRemoteRepository(String repositoryId, String url) {
        RemoteRepository result = new RemoteRepository.Builder(repositoryId, "default", url).build();
        if (result.getAuthentication() == null || result.getProxy() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(result);
            if (result.getAuthentication() == null) {
                builder.setAuthentication(this.session.getRepositorySession().getAuthenticationSelector().getAuthentication(result));
            }
            if (result.getProxy() == null) {
                builder.setProxy(this.session.getRepositorySession().getProxySelector().getProxy(result));
            }
            result = builder.build();
        }
        return result;
    }

    protected void deploy(RepositorySystemSession session, DeployRequest deployRequest) throws MojoExecutionException {
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        Throwable exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter);
                }
                this.repositorySystem.deploy(session, deployRequest);
                exception = null;
                break;
            }
            catch (DeploymentException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    this.getLog().warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    this.getLog().debug(e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
        }
    }
}

