/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectStepData;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

class ReverseTreeRepositoryListener
extends AbstractRepositoryListener {
    ReverseTreeRepositoryListener() {
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        Artifact nodeArtifact;
        Objects.requireNonNull(event, "event cannot be null");
        if (!ReverseTreeRepositoryListener.isLocalRepositoryArtifact(event.getSession(), event.getArtifact())) {
            return;
        }
        CollectStepData collectStepTrace = ReverseTreeRepositoryListener.lookupCollectStepData(event.getTrace());
        if (collectStepTrace == null) {
            return;
        }
        Artifact resolvedArtifact = event.getArtifact();
        if (ReverseTreeRepositoryListener.isInScope(resolvedArtifact, nodeArtifact = collectStepTrace.getNode().getArtifact())) {
            Dependency node = collectStepTrace.getNode();
            ArrayList<String> trackingData = new ArrayList<String>();
            trackingData.add(node + " (" + collectStepTrace.getContext() + ")");
            String indent = "";
            ListIterator<DependencyNode> iter = collectStepTrace.getPath().listIterator(collectStepTrace.getPath().size());
            while (iter.hasPrevious()) {
                DependencyNode curr = iter.previous();
                indent = indent + "  ";
                trackingData.add(indent + curr + " (" + collectStepTrace.getContext() + ")");
            }
            try {
                Path trackingDir = resolvedArtifact.getFile().getParentFile().toPath().resolve(".tracking");
                Files.createDirectories(trackingDir, new FileAttribute[0]);
                Path trackingFile = trackingDir.resolve(collectStepTrace.getPath().get(0).getArtifact().toString().replace(":", "_"));
                Files.write(trackingFile, trackingData, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static boolean isLocalRepositoryArtifact(RepositorySystemSession session, Artifact artifact) {
        return artifact.getFile().getPath().startsWith(session.getLocalRepository().getBasedir().getPath());
    }

    static CollectStepData lookupCollectStepData(RequestTrace trace) {
        CollectStepData collectStepTrace = null;
        while (trace != null) {
            if (trace.getData() instanceof CollectStepData) {
                collectStepTrace = (CollectStepData)trace.getData();
                break;
            }
            trace = trace.getParent();
        }
        return collectStepTrace;
    }

    static boolean isInScope(Artifact artifact, Artifact nodeArtifact) {
        return Objects.equals(artifact.getGroupId(), nodeArtifact.getGroupId()) && Objects.equals(artifact.getArtifactId(), nodeArtifact.getArtifactId()) && Objects.equals(artifact.getVersion(), nodeArtifact.getVersion());
    }
}

