/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public class MapMatcher {
    private Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private PatternMatcher pm;
    private Map<String, String> attributes;

    public MapMatcher(Map<String, String> attributes, PatternMatcher pm) {
        this.attributes = attributes;
        this.pm = pm;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            this.matchers.put(entry.getKey(), pm.getMatcher(value));
        }
    }

    public boolean matches(Map<String, String> m3) {
        for (Map.Entry<String, Matcher> entry : this.matchers.entrySet()) {
            Matcher matcher = entry.getValue();
            String value = m3.get(entry.getKey());
            if (value != null && matcher.matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.attributes + " (" + this.pm.getName() + ")";
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public PatternMatcher getPatternMatcher() {
        return this.pm;
    }
}

