/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option;

import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.OptionsSpecType;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class Options {
    protected List<String> optionList;
    protected boolean immutable = false;

    public Options() {
    }

    public Options(String ... options) {
        this.setOptions(options);
    }

    public void setOptions(String ... options) {
        if (options != null) {
            this.optionList = new ArrayList<String>();
            for (String option : options) {
                if (!StringUtils.isNotBlank(option)) continue;
                this.optionList.add(option);
            }
            if (!this.optionList.isEmpty()) {
                this.setImmutable(true);
            }
        } else {
            this.optionList = null;
        }
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public List<String> getOptions() {
        return this.optionList;
    }

    public List<String> processFields(@Nonnull String optionSpecsString, Object ... opts) throws OptionsException {
        P4JavaExceptions.throwOptionsExceptionIfConditionFails(Objects.nonNull(optionSpecsString), "options specs are required", new Object[0]);
        ArrayList<String> optsList = new ArrayList<String>();
        if (Objects.nonNull(opts)) {
            String[] optionSpecExpressions = optionSpecsString.split(" ");
            P4JavaExceptions.throwOptionsExceptionIfConditionFails(optionSpecExpressions.length == opts.length, "specs vs opts size mismatch in options processor", new Object[0]);
            String currentOptionSpecExpression = "";
            try {
                for (int i = 0; i < opts.length; ++i) {
                    currentOptionSpecExpression = optionSpecExpressions[i];
                    P4JavaExceptions.throwOptionsExceptionIfConditionFails(StringUtils.isNotBlank(currentOptionSpecExpression), "null options spec in options processor: %s", optionSpecsString);
                    String[] optSpecParts = currentOptionSpecExpression.split(":");
                    P4JavaExceptions.throwOptionsExceptionIfConditionFails(optSpecParts.length == 2 || optSpecParts.length == 3, "null options spec in options processor: %s", optionSpecsString);
                    String ruleName = "";
                    if (optSpecParts.length >= 3) {
                        ruleName = optSpecParts[2];
                    }
                    String serverOptionStr = optSpecParts[1];
                    String optSpecType = optSpecParts[0];
                    OptionsSpecType p4CommandOptions = OptionsSpecType.of(optSpecType);
                    optsList.addAll(p4CommandOptions.getP4CommandOptionFields(ruleName, serverOptionStr, opts[i]));
                }
            }
            catch (Exception exc) {
                P4JavaExceptions.throwOptionsException(exc, "bad conversion encountered in options processor with option string '%s': %s", currentOptionSpecExpression, exc.getLocalizedMessage());
            }
        }
        return optsList;
    }

    public abstract List<String> processOptions(IServer var1) throws OptionsException;
}

