/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.option.server.LoginOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ILogoutDelegator;
import org.apache.commons.lang3.StringUtils;

public class LogoutDelegator
extends BaseDelegator
implements ILogoutDelegator {
    public LogoutDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public void logout() throws ConnectionException, RequestException, AccessException, ConfigException {
        try {
            this.logout(new LoginOptions());
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public void logout(LoginOptions opts) throws P4JavaException {
        if (StringUtils.isBlank(this.server.getAuthTicket())) {
            return;
        }
        this.execMapCmdList(CmdSpec.LOGOUT, Parameters.processParameters(opts, this.server), null);
        this.server.setAuthTicket(null);
    }
}

