/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.DeleteLabelOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ILabelDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class LabelDelegator
extends BaseDelegator
implements ILabelDelegator {
    public LabelDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public ILabel getLabel(String labelName) throws ConnectionException, RequestException, AccessException {
        Validate.notBlank(labelName, "Label name shouldn't null or empty.", new Object[0]);
        Label label = null;
        String OFLAG = "-o";
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-o", labelName}, null);
        if (Objects.isNull(resultMaps)) {
            Log.warn("Unexpected null map array returned to ServerImpl.getLabel()", new Object[0]);
        } else {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map)) continue;
                ResultMapParser.handleErrorStr(map);
                if (ResultMapParser.isInfoMessage(map) || !ResultMapParser.isExistClientOrLabelOrUser(map)) continue;
                label = new Label(map, this.server);
            }
        }
        return label;
    }

    @Override
    public String createLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(label);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String updateLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(label);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    @Override
    public String deleteLabel(String labelName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteLabel(labelName, new DeleteLabelOptions().setForce(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteLabel(String labelName, DeleteLabelOptions opts) throws P4JavaException {
        Validate.notBlank(labelName, "Label name shouldn't null or empty.", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LABEL, Parameters.processParameters((Options)opts, null, new String[]{"-d", labelName}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }
}

