/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IJobDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class JobDelegator
extends BaseDelegator
implements IJobDelegator {
    public JobDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public IJob createJob(@Nonnull Map<String, Object> fieldMap) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(fieldMap);
        int wordLength = 3;
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-i"}, fieldMap);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                String potentialJobId;
                String[] words;
                ResultMapParser.handleErrorStr(map);
                String infoStr = ResultMapParser.getInfoStr(map);
                if (!StringUtils.contains((CharSequence)infoStr, "Job ") || !StringUtils.contains((CharSequence)infoStr, " saved") || (words = StringUtils.split(infoStr, " ")).length != 3 || !StringUtils.isNotBlank(potentialJobId = words[1])) continue;
                return this.getJob(potentialJobId);
            }
        }
        return null;
    }

    @Override
    public String deleteJob(String jobId) throws ConnectionException, RequestException, AccessException {
        Validate.notBlank(jobId, "JobId should not be null or empty", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-d", jobId}, null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public IJob getJob(String jobId) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(jobId, "JobId should not be null", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-o", jobId}, null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, map -> new Job(this.server, (Map<String, Object>)map));
    }

    @Override
    public String updateJob(@Nonnull IJob job) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(job);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.JOB, new String[]{"-i"}, job.getRawFields());
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }
}

